/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.network.packets;

import java.io.IOException;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCamouflageSelectClient extends ForestryPacket implements IForestryPacketClient {
	private final BlockPos pos;
	private final ItemStack camouflageStack;
	private final String camouflageType;
	private final CamouflageSelectionType selectionType;

	public PacketCamouflageSelectClient(ICamouflageHandler handler, String camouflageType, CamouflageSelectionType selectionType) {
		this.pos = handler.getCoordinates();
		this.camouflageStack = handler.getCamouflageBlock(camouflageType);
		this.selectionType = selectionType;
		this.camouflageType = camouflageType;
	}

	@Override
	public PacketIdClient getPacketId() {
		return PacketIdClient.CAMOUFLAGE_SELECTION;
	}

	@Override
	protected void writeData(PacketBufferForestry data) throws IOException {
		data.func_179255_a(pos);
		data.writeShort(selectionType.ordinal());
		data.func_180714_a(camouflageType);
		data.func_150788_a(camouflageStack);
	}

	@SideOnly(Side.CLIENT)
	public static class Handler implements IForestryPacketHandlerClient {

		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
			BlockPos pos = data.func_179259_c();
			CamouflageSelectionType selectionType = CamouflageSelectionType.values()[data.readShort()];
			String camouflageType = data.readString();
			ItemStack camouflageStack = data.func_150791_c();

			TileEntity tile = player.field_70170_p.func_175625_s(pos);
			ICamouflageHandler handler;
			if (selectionType == CamouflageSelectionType.MULTIBLOCK) {
				if (tile instanceof IMultiblockComponent) {
					IMultiblockController controller = ((IMultiblockComponent) tile).getMultiblockLogic().getController();

					if (controller instanceof ICamouflageHandler) {
						handler = (ICamouflageHandler) controller;
						if (handler.setCamouflageBlock(camouflageType, camouflageStack, false)) {
							for (IMultiblockComponent comp : controller.getComponents()) {
								if (comp instanceof ICamouflagedTile) {
									ICamouflagedTile camBlock = (ICamouflagedTile) comp;
									if (camBlock.getCamouflageType().equals(camouflageType)) {
										player.field_70170_p.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
									}
								}
							}
						}
					}
				}
			} else if (selectionType == CamouflageSelectionType.TILE) {
				if (tile instanceof ICamouflageHandler) {
					handler = (ICamouflageHandler) tile;
					if (handler.setCamouflageBlock(camouflageType, camouflageStack, false)) {
						player.field_70170_p.func_175704_b(pos, pos);
					}
				}
			}
		}
	}
}
