/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.blocks.BlockCocoon;
import forestry.lepidopterology.blocks.CocoonStateMapper;
import forestry.lepidopterology.blocks.MaterialCocoon;
import forestry.lepidopterology.blocks.PropertyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolidCocoon
extends Block
implements ITileEntityProvider,
IStateMapperRegister,
IItemModelRegister {
    private static final PropertyCocoon COCOON = AlleleButterflyCocoon.COCOON;

    public BlockSolidCocoon() {
        super(MaterialCocoon.INSTANCE);
        this.setHarvestLevel("scoop", 0);
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COCOON, (Comparable)ButterflyAlleles.cocoonDefault).func_177226_a((IProperty)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COCOON, AlleleButterflyCocoon.AGE});
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileCocoon cocoon = TileUtil.getTile(world, pos, TileCocoon.class);
        if (cocoon != null) {
            state = state.func_177226_a((IProperty)COCOON, (Comparable)cocoon.getCaterpillar().getGenome().getCocoon()).func_177226_a((IProperty)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(cocoon.getAge()));
        }
        return super.func_176221_a(state, world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CocoonStateMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "cocoon_late");
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile;
        if (this.canHarvestBlock((IBlockAccess)world, pos, player) && (tile = world.func_175625_s(pos)) instanceof TileCocoon) {
            TileCocoon cocoon = (TileCocoon)tile;
            NonNullList<ItemStack> drops = cocoon.getCocoonDrops();
            for (ItemStack stack : drops) {
                if (stack == null) continue;
                ItemStackUtil.dropItemStackAsEntity(stack, world, pos);
            }
        }
        return world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCocoon(true);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175698_g(pos);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BlockCocoon.BOUNDING_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BlockCocoon.BOUNDING_BOX;
    }
}

