/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.greenhouse.gui.ContainerGreenhouseButterflyHatch;
import forestry.greenhouse.gui.GuiGreenhouseButterflyHatch;
import forestry.greenhouse.inventory.InventoryGreenhouseButterflyHatch;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileGreenhouseButterflyHatch extends TileGreenhouse implements IGreenhouseComponent.ButterflyHatch {

	private final InventoryGreenhouseButterflyHatch inventory;

	public TileGreenhouseButterflyHatch() {
		this.inventory = new InventoryGreenhouseButterflyHatch(this);
	}

	@Override
	public IInventoryAdapter getInternalInventory() {
		return inventory;
	}

	@Override
	public NonNullList<ItemStack> addCocoonLoot(IButterflyCocoon cocoon) {
		NonNullList<ItemStack> loots = NonNullList.func_191196_a();
		for (ItemStack loot : cocoon.getCaterpillar().getCocoonDrop(cocoon)) {
			if (!InventoryUtil.tryAddStack(this, loot, 0, InventoryGreenhouseButterflyHatch.SLOTS, true)) {
				loots.add(loot);
			}
		}
		return loots;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public GuiContainer getGui(EntityPlayer player, int data) {
		return new GuiGreenhouseButterflyHatch(player, this);
	}

	@Override
	public Container getContainer(EntityPlayer player, int data) {
		return new ContainerGreenhouseButterflyHatch(player.field_71071_by, this);
	}

}
