/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.FabricatorRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FabricatorRecipeManager
implements IFabricatorManager {
    private static final Set<IFabricatorRecipe> recipes = new HashSet<IFabricatorRecipe>();

    @Override
    public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
        ShapedRecipeCustom patternRecipe = new ShapedRecipeCustom(result, pattern);
        NonNullList<NonNullList<ItemStack>> ingredients = patternRecipe.getIngredients();
        FabricatorRecipe recipe = new FabricatorRecipe(plan, molten, result, ingredients, patternRecipe.getOreDicts(), patternRecipe.getWidth(), patternRecipe.getHeight());
        this.addRecipe(recipe);
    }

    @Nullable
    public static Pair<IFabricatorRecipe, String[][]> findMatchingRecipe(ItemStack plan, IInventory resources) {
        ItemStack[][] gridResources = RecipeUtil.getResources(resources);
        for (IFabricatorRecipe recipe : recipes) {
            String[][] oreDicts;
            if (!recipe.getPlan().func_190926_b() && !ItemStackUtil.isCraftingEquivalent(recipe.getPlan(), plan) || (oreDicts = RecipeUtil.matches(recipe.getIngredients(), recipe.getOreDicts(), recipe.getWidth(), recipe.getHeight(), gridResources)) == null) continue;
            return Pair.of((Object)recipe, (Object)oreDicts);
        }
        return Pair.of(null, null);
    }

    public static boolean isPlan(ItemStack plan) {
        for (IFabricatorRecipe recipe : recipes) {
            if (!ItemStackUtil.isIdenticalItem(recipe.getPlan(), plan)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRecipe(IFabricatorRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IFabricatorRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<IFabricatorRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

