/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.genetics.LeafProvider;
import forestry.core.genetics.alleles.AlleleSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpeciesBuilder,
IAlleleTreeSpecies {
    private final ITreeGenerator generator;
    private final IWoodProvider woodProvider;
    private final IGermlingModelProvider germlingModelProvider;
    private final ILeafSpriteProvider leafSpriteProvider;
    private final List<IFruitFamily> fruits = new ArrayList<IFruitFamily>();
    private final String modID;
    private EnumPlantType nativeType = EnumPlantType.Plains;
    private final ILeafProvider leafProvider;

    public AlleleTreeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean isDominant, IClassification branch, String binomial, String modID, ILeafSpriteProvider leafSpriteProvider, IGermlingModelProvider germlingModelProvider, IWoodProvider woodProvider, ITreeGenerator generator) {
        this(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial, modID, leafSpriteProvider, germlingModelProvider, woodProvider, generator, new LeafProvider());
    }

    public AlleleTreeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean isDominant, IClassification branch, String binomial, String modID, ILeafSpriteProvider leafIconProvider, IGermlingModelProvider germlingModelProvider, IWoodProvider woodProvider, ITreeGenerator generator, ILeafProvider leafProvider) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial);
        this.generator = generator;
        this.germlingModelProvider = germlingModelProvider;
        this.woodProvider = woodProvider;
        this.leafSpriteProvider = leafIconProvider;
        this.leafProvider = leafProvider;
        this.modID = modID;
    }

    @Override
    public IAlleleTreeSpecies build() {
        AlleleManager.alleleRegistry.registerAllele(this, EnumTreeChromosome.SPECIES);
        this.leafProvider.init(this);
        return this;
    }

    @Override
    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    @Override
    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    public List<IFruitFamily> getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public ITreeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public ILeafSpriteProvider getLeafSpriteProvider() {
        return this.leafSpriteProvider;
    }

    @Override
    public int getSpriteColour(int renderPass) {
        return this.leafSpriteProvider.getColor(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getGermlingModel(EnumGermlingType type) {
        return this.germlingModelProvider.getModel(type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        return this.germlingModelProvider.getSpriteColor(type, renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
        this.germlingModelProvider.registerModels(item, manager, type);
    }

    @Override
    public IWoodProvider getWoodProvider() {
        return this.woodProvider;
    }

    @Override
    public ILeafProvider getLeafProvider() {
        return this.leafProvider;
    }

    @Override
    public String getModID() {
        return this.modID;
    }

    @Override
    public int compareTo(IAlleleTreeSpecies o) {
        return 0;
    }
}

