/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.fluids.ITankManager;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.ILiquidTankTile;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTankLevelUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final int tankIndex;
    @Nullable
    private final FluidStack contents;

    public PacketTankLevelUpdate(ILiquidTankTile tileEntity, int tankIndex, @Nullable FluidStack contents) {
        this.pos = tileEntity.getCoordinates();
        this.tankIndex = tankIndex;
        this.contents = contents;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TANK_LEVEL_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.func_150787_b(this.tankIndex);
        data.writeFluidStack(this.contents);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            int tankIndex = data.func_150792_a();
            FluidStack contents = data.readFluidStack();
            TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof ILiquidTankTile) {
                ITankManager tankManager = ((ILiquidTankTile)tileEntity).getTankManager();
                tankManager.processTankUpdate(tankIndex, contents);
            }
        }
    }
}

