/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food.gui;

import forestry.api.food.BeverageManager;
import forestry.core.config.Constants;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import forestry.food.inventory.ItemInventoryInfuser;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiInfuser extends GuiForestry<ContainerInfuser> {
	private final ItemInventoryInfuser itemInventory;
	private int startX;
	private int startY;

	public GuiInfuser(InventoryPlayer inventoryplayer, ItemInventoryInfuser itemInventory) {
		super(Constants.TEXTURE_PATH_GUI + "/infuser.png", new ContainerInfuser(inventoryplayer, itemInventory));

		this.itemInventory = itemInventory;
		this.field_146999_f = 176;
		this.field_147000_g = 185;
	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {
		super.func_146976_a(var1, mouseX, mouseY);

		for (int l = 2; l < itemInventory.func_70302_i_(); l++) {
			String description = BeverageManager.ingredientManager.getDescription(itemInventory.func_70301_a(l));
			if (description == null) {
				description = "(No effect)";
			}

			int row = (l - 2) * 20;
			field_146289_q.func_78276_b(description, startX + 32, startY + 16 + row, ColourProperties.INSTANCE.get("gui.screen"));
		}
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		startX = (this.field_146294_l - this.field_146999_f) / 2;
		startY = (this.field_146295_m - this.field_147000_g) / 2;
	}

	@Override
	protected void addLedgers() {

	}
}
