/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.network.packets;

import java.io.IOException;

import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.IContainerSocketed;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class PacketChipsetClick extends ForestryPacket implements IForestryPacketServer {
	private final int slot;

	public PacketChipsetClick(int slot) {
		this.slot = slot;
	}

	@Override
	protected void writeData(PacketBufferForestry data) throws IOException {
		data.func_150787_b(slot);
	}

	@Override
	public PacketIdServer getPacketId() {
		return PacketIdServer.CHIPSET_CLICK;
	}

	public static class Handler implements IForestryPacketHandlerServer {
		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
			int slot = data.func_150792_a();

			if (player.field_71070_bA instanceof IContainerSocketed) {
				ItemStack itemstack = player.field_71071_by.func_70445_o();
				if (itemstack.func_77973_b() instanceof ItemCircuitBoard) {
					((IContainerSocketed) player.field_71070_bA).handleChipsetClickServer(slot, player, itemstack);
				}
			}
		}
	}
}
