/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.proxy;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelManager;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.BlockRegistryGreenhouse;
import forestry.greenhouse.models.ModelGreenhouse;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyGreenhouseClient
extends ProxyGreenhouse {
    @Override
    public void initializeModels() {
        BlockRegistryGreenhouse blocks = PluginGreenhouse.getBlocks();
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        for (BlockGreenhouseType greenhouseType : BlockGreenhouseType.VALUES) {
            BlockGreenhouse greenhouseBlock = blocks.getGreenhouseBlock(greenhouseType);
            if (greenhouseType == BlockGreenhouseType.DOOR) {
                ModelManager.getInstance().registerCustomBlockModel(new BlockModelEntry(new ModelResourceLocation("forestry:greenhouse." + (Object)((Object)greenhouseType), "camouflage"), null, new ModelGreenhouse(), greenhouseBlock, false));
                continue;
            }
            if (greenhouseType != BlockGreenhouseType.BUTTERFLY_HATCH ? greenhouseType == BlockGreenhouseType.WINDOW || greenhouseType == BlockGreenhouseType.WINDOW_UP : !ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) continue;
            if (greenhouseBlock == null) continue;
            ModelResourceLocation blockModelLocation = new ModelResourceLocation("forestry:greenhouse." + (Object)((Object)greenhouseType));
            ModelResourceLocation itemModelLocation = new ModelResourceLocation("forestry:greenhouse", "inventory");
            BlockModelEntry blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelGreenhouse(), greenhouseBlock);
            ModelManager.getInstance().registerCustomBlockModel(blockModelIndex);
        }
    }
}

