/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.network.packets;

import java.io.IOException;

import forestry.apiculture.tiles.TileCandle;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCandleUpdate extends ForestryPacket implements IForestryPacketClient {
	private final BlockPos pos;
	private final int colour;
	private final boolean lit;

	public PacketCandleUpdate(TileCandle tileCandle) {
		pos = tileCandle.func_174877_v();
		colour = tileCandle.getColour();
		lit = tileCandle.isLit();
	}

	@Override
	public PacketIdClient getPacketId() {
		return PacketIdClient.CANDLE_UPDATE;
	}

	@Override
	protected void writeData(PacketBufferForestry data) throws IOException {
		data.func_179255_a(pos);
		data.writeInt(colour);
		data.writeBoolean(lit);
	}

	@SideOnly(Side.CLIENT)
	public static class Handler implements IForestryPacketHandlerClient {
		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
			BlockPos pos = data.func_179259_c();
			int colour = data.readInt();
			boolean lit = data.readBoolean();

			TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
			if (tileEntity instanceof TileCandle) {
				((TileCandle) tileEntity).onPacketUpdate(colour, lit);
			}
		}
	}
}
