/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.gui.ContainerCentrifuge;
import forestry.factory.gui.GuiCentrifuge;
import forestry.factory.inventory.InventoryCentrifuge;
import forestry.factory.recipes.CentrifugeRecipeManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCentrifuge
extends TilePowered
implements ISocketable,
ISidedInventory,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 3200;
    private static final int ENERGY_PER_RECIPE_TIME = 160;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    private ICentrifugeRecipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();

    public TileCentrifuge() {
        super(800, 5000);
        this.setInternalInventory(new InventoryCentrifuge(this));
        this.craftPreviewInventory = new InventoryCraftResult();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingProducts.add(new ItemStack(nbttagcompound1));
        }
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (!chip.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public boolean workCycle() {
        if (this.tryAddPending()) {
            return true;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.craftPreviewInventory.func_70299_a(0, ItemStack.field_190927_a);
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        NonNullList<ItemStack> products = this.currentRecipe.getProducts(this.field_145850_b.field_73012_v);
        this.pendingProducts.addAll((Collection<ItemStack>)products);
        ItemStack previewStack = this.getInternalInventory().func_70301_a(0).func_77946_l();
        previewStack.func_190920_e(1);
        this.craftPreviewInventory.func_70299_a(0, previewStack);
        this.getInternalInventory().func_70298_a(0, 1);
        return true;
    }

    private void checkRecipe() {
        ItemStack resource = this.func_70301_a(0);
        ICentrifugeRecipe matchingRecipe = CentrifugeRecipeManager.findMatchingRecipe(resource);
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 160);
            }
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        boolean added = InventoryUtil.tryAddStack((IInventory)this, next, 1, 9, true);
        if (added) {
            this.pendingProducts.pop();
            if (this.pendingProducts.isEmpty()) {
                this.craftPreviewInventory.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
        return added;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return (float)inventory.func_70301_a(0).func_190916_E() / (float)inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (!this.pendingProducts.isEmpty()) {
            return true;
        }
        this.checkRecipe();
        boolean hasResource = !this.func_70301_a(0).func_190926_b();
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResource, EnumErrorCode.NO_RESOURCE);
        return hasResource;
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (!stack.func_190926_b() && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (!this.sockets.func_70301_a(slot).func_190926_b() && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        if (stack.func_190926_b()) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.MACHINE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiCentrifuge(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerCentrifuge(player.field_71071_by, this);
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }
}

