/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.NBTUtilForestry;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFruitPod
extends TileEntity
implements IFruitBearer,
IStreamable {
    private static final short MAX_MATURITY = 2;
    private static final ITreeGenome defaultGenome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getDefaultTemplate());
    private static final IAlleleFruit defaultAllele = (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("forestry.fruitCocoa");
    private ITreeGenome genome = defaultGenome;
    private IAlleleFruit allele = defaultAllele;
    private short maturity;
    private float sappiness;

    public void setProperties(ITreeGenome genome, IAlleleFruit allele, float sappiness) {
        this.genome = genome;
        this.allele = allele;
        this.sappiness = sappiness;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        IAllele stored = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i("UID"));
        this.allele = stored instanceof IAlleleFruit ? (IAlleleFruit)stored : defaultAllele;
        this.maturity = nbttagcompound.func_74765_d("MT");
        this.sappiness = nbttagcompound.func_74760_g("SP");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("UID", this.allele.getUID());
        nbttagcompound.func_74777_a("MT", this.maturity);
        nbttagcompound.func_74776_a("SP", this.sappiness);
        return nbttagcompound;
    }

    public void onBlockTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.canMature() && rand.nextFloat() <= this.sappiness) {
            this.addRipeness(0.5f);
        }
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    public short getMaturity() {
        return this.maturity;
    }

    public ItemStack getPickBlock() {
        Map<ItemStack, Float> products = this.allele.getProvider().getProducts();
        ItemStack pickBlock = ItemStack.field_190927_a;
        Float maxChance = Float.valueOf(0.0f);
        for (Map.Entry<ItemStack, Float> product : products.entrySet()) {
            if (!(maxChance.floatValue() < product.getValue().floatValue())) continue;
            maxChance = product.getValue();
            pickBlock = product.getKey().func_77946_l();
        }
        pickBlock.func_190920_e(1);
        return pickBlock;
    }

    public NonNullList<ItemStack> getDrops() {
        return this.allele.getProvider().getFruits(this.genome, this.field_145850_b, this.func_174877_v(), this.maturity);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        return this.allele.getProvider().getFamily();
    }

    @Override
    public NonNullList<ItemStack> pickFruit(ItemStack tool) {
        NonNullList<ItemStack> fruits = this.getDrops();
        this.maturity = 0;
        IBlockState oldState = this.field_145850_b.func_180495_p(this.func_174877_v());
        IBlockState newState = oldState.func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0));
        BlockUtil.setBlockWithBreakSound(this.field_145850_b, this.func_174877_v(), newState, oldState);
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        int age;
        int previousAge = (int)Math.floor(this.maturity);
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        if (this.maturity > 2) {
            this.maturity = (short)2;
        }
        if ((age = (int)Math.floor(this.maturity)) - previousAge > 0) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(age));
            this.field_145850_b.func_175656_a(this.func_174877_v(), state);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        if (this.allele != defaultAllele) {
            data.func_180714_a(this.allele.getUID());
        } else {
            data.func_180714_a("");
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        IAllele stored = AlleleManager.alleleRegistry.getAllele(data.readString());
        this.allele = stored instanceof IAlleleFruit ? (IAlleleFruit)stored : defaultAllele;
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }
}

