/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.inventory.InventoryAnalyzer;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.InventoryUtil;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileAnalyzer
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TIME_TO_ANALYZE = 125;
    private static final int HONEY_REQUIRED = 100;
    private static final int ENERGY_PER_WORK_CYCLE = 20320;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final IInventory invInput;
    private final IInventory invOutput;
    @Nullable
    private IIndividual specimenToAnalyze;
    private ItemStack individualOnDisplayClient = ItemStack.field_190927_a;

    public TileAnalyzer() {
        super(800, 5000);
        this.setInternalInventory(new InventoryAnalyzer(this));
        this.resourceTank = new FilteredTank(10000).setFilters(Fluids.FOR_HONEY.getFluid());
        this.tankManager = new TankManager(this, this.resourceTank);
        this.invInput = new InventoryMapper((IInventory)this.getInternalInventory(), 2, 6);
        this.invOutput = new InventoryMapper((IInventory)this.getInternalInventory(), 8, 4);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (!stackToAnalyze.func_190926_b()) {
            this.specimenToAnalyze = AlleleManager.alleleRegistry.getIndividual(stackToAnalyze);
        }
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 1);
        }
    }

    @Override
    public boolean workCycle() {
        boolean added;
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (stackToAnalyze.func_190926_b() || this.specimenToAnalyze == null) {
            return false;
        }
        if (!this.specimenToAnalyze.isAnalyzed()) {
            FluidStack drained = this.resourceTank.drain(100, false);
            if (drained == null || drained.amount != 100) {
                return false;
            }
            this.resourceTank.drain(100, true);
            this.specimenToAnalyze.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.specimenToAnalyze.writeToNBT(nbttagcompound);
            stackToAnalyze.func_77982_d(nbttagcompound);
        }
        if (!(added = InventoryUtil.tryAddStack(this.invOutput, stackToAnalyze, true))) {
            return false;
        }
        this.func_70299_a(0, ItemStack.field_190927_a);
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        Proxies.net.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
        return true;
    }

    @Nullable
    private Integer getInputSlotIndex() {
        for (int slotIndex = 0; slotIndex < this.invInput.func_70302_i_(); ++slotIndex) {
            ItemStack inputStack = this.invInput.func_70301_a(slotIndex);
            if (!AlleleManager.alleleRegistry.isIndividual(inputStack)) continue;
            return slotIndex;
        }
        return null;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.func_150788_a(displayStack);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.func_150791_c();
        this.tankManager.readData(data);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public boolean hasWork() {
        this.moveSpecimenToAnalyzeSlot();
        ItemStack specimen = this.func_70301_a(0);
        boolean hasSpecimen = !specimen.func_190926_b();
        boolean hasResource = true;
        boolean hasSpace = true;
        if (hasSpecimen) {
            hasSpace = InventoryUtil.tryAddStack(this.invOutput, specimen, true, false);
            if (this.specimenToAnalyze != null && !this.specimenToAnalyze.isAnalyzed()) {
                FluidStack drained = this.resourceTank.drain(100, false);
                hasResource = drained != null && drained.amount == 100;
            }
        }
        this.getErrorLogic().setCondition(!hasSpecimen, EnumErrorCode.NO_SPECIMEN);
        this.getErrorLogic().setCondition(!hasResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        this.getErrorLogic().setCondition(!hasSpace, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasSpecimen && hasResource && hasSpace;
    }

    private void moveSpecimenToAnalyzeSlot() {
        if (!this.func_70301_a(0).func_190926_b()) {
            return;
        }
        Integer slotIndex = this.getInputSlotIndex();
        if (slotIndex == null) {
            return;
        }
        ItemStack inputStack = this.invInput.func_70301_a(slotIndex.intValue());
        if (inputStack.func_190926_b()) {
            return;
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture") && !TreeManager.treeRoot.isMember(inputStack)) {
            inputStack = GeneticsUtil.convertToGeneticEquivalent(inputStack);
        }
        this.specimenToAnalyze = AlleleManager.alleleRegistry.getIndividual(inputStack);
        if (this.specimenToAnalyze == null) {
            return;
        }
        this.func_70299_a(0, inputStack);
        this.invInput.func_70299_a(slotIndex.intValue(), ItemStack.field_190927_a);
        if (this.specimenToAnalyze.isAnalyzed()) {
            this.setTicksPerWorkCycle(1);
            this.setEnergyPerWorkCycle(0);
        } else {
            this.setTicksPerWorkCycle(125);
            this.setEnergyPerWorkCycle(20320);
        }
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        Proxies.net.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.field_145850_b.field_72995_K) {
            return this.individualOnDisplayClient;
        }
        return this.func_70301_a(0);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiAnalyzer(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerAnalyzer(player.field_71071_by, this);
    }
}

