/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import forestry.api.climate.IClimateControlProvider;
import forestry.api.climate.IClimateInfo;
import forestry.core.climate.ClimateInfo;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.network.packets.PacketUpdateClimateControl;
import forestry.core.proxy.Proxies;
import forestry.core.render.ColourProperties;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.WidgetCamouflageTab;
import forestry.greenhouse.gui.WidgetClimatePillar;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.io.IOException;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGreenhouse
extends GuiForestryTitled<ContainerGreenhouse> {
    private static final Predicate<String> numberFilter = text -> {
        if (text == null) {
            return false;
        }
        if (!text.isEmpty() && text.length() > 1 && !text.contains(".")) {
            return false;
        }
        if (text.length() > 7) {
            return false;
        }
        Float f = Floats.tryParse((String)text);
        return text.isEmpty() || f != null && Floats.isFinite((float)f.floatValue()) && f.floatValue() >= 0.0f;
    };
    private final TileGreenhouse tile;
    private GuiTextField humidityField;
    private GuiTextField temperatureField;
    private boolean fieldsEnabeled;

    public GuiGreenhouse(EntityPlayer player, TileGreenhouse tile) {
        super("textures/gui/greenhouse.png", new ContainerGreenhouse(player.field_71071_by, tile), tile);
        this.tile = tile;
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 16, 0).setOverlayOrigin(176, 0));
        int x = 3;
        WidgetCamouflageTab previous = new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + x, this.field_147009_r - 25, ((MultiblockLogicGreenhouse)tile.getMultiblockLogic()).getController(), tile, "block");
        this.widgetManager.add(previous);
        previous = new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + (x += 50 + (previous.getHandlerSlot() != null ? 20 : 0)), this.field_147009_r - 25, ((MultiblockLogicGreenhouse)tile.getMultiblockLogic()).getController(), tile, "glass");
        this.widgetManager.add(previous);
        this.widgetManager.add(new WidgetCamouflageTab(this.widgetManager, this.field_147003_i + (x += 50 + (previous.getHandlerSlot() != null ? 20 : 0)), this.field_147009_r - 25, ((MultiblockLogicGreenhouse)tile.getMultiblockLogic()).getController(), tile, "door"));
        this.widgetManager.add(new WidgetClimatePillar(this.widgetManager, this.field_147003_i - 23, this.field_147009_r + 5));
        this.fieldsEnabeled = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.temperatureField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 64, this.field_147009_r + 31, 50, 10);
        this.humidityField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 64, this.field_147009_r + 61, 50, 10);
        this.temperatureField.func_175205_a(numberFilter);
        this.humidityField.func_175205_a(numberFilter);
        this.temperatureField.func_146185_a(false);
        this.humidityField.func_146185_a(false);
        IGreenhouseControllerInternal controller = ((MultiblockLogicGreenhouse)this.tile.getMultiblockLogic()).getController();
        if (controller == null || controller.getControlClimate() == ClimateInfo.MAX) {
            this.temperatureField.func_146184_c(false);
            this.temperatureField.func_146189_e(false);
            this.humidityField.func_146184_c(false);
            this.humidityField.func_146189_e(false);
            this.fieldsEnabeled = false;
        } else {
            IClimateInfo info = controller.getControlClimate();
            this.temperatureField.func_146180_a(Float.toString(info.getTemperature()));
            this.humidityField.func_146180_a(Float.toString(info.getHumidity()));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.fieldsEnabeled) {
            if (!this.humidityField.func_146201_a(typedChar, keyCode) && !this.temperatureField.func_146201_a(typedChar, keyCode)) {
                super.func_73869_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.fieldsEnabeled) {
            boolean temperatureWasFocused = this.temperatureField.func_146206_l();
            boolean humidityWasFocused = this.humidityField.func_146206_l();
            this.temperatureField.func_146192_a(mouseX, mouseY, mouseButton);
            this.humidityField.func_146192_a(mouseX, mouseY, mouseButton);
            IGreenhouseControllerInternal provider = ((MultiblockLogicGreenhouse)this.tile.getMultiblockLogic()).getController();
            if (temperatureWasFocused && !this.temperatureField.func_146206_l() || humidityWasFocused && !this.humidityField.func_146206_l()) {
                float temp = this.parseField(this.temperatureField);
                float hum = this.parseField(this.humidityField);
                this.setClimate(provider, temp, hum);
            }
            Proxies.net.sendToServer(new PacketUpdateClimateControl(provider));
        }
    }

    public void setClimate(float temp) {
        this.setClimate(((MultiblockLogicGreenhouse)this.tile.getMultiblockLogic()).getController(), temp);
    }

    public void setClimate(IClimateControlProvider provider, float temp) {
        IClimateInfo info = provider.getControlClimate();
        this.setClimate(provider, temp, info.getHumidity());
    }

    public void setClimate(IClimateControlProvider provider, float temp, float hum) {
        this.temperatureField.func_146180_a(Float.toString(temp));
        this.humidityField.func_146180_a(Float.toString(hum));
        provider.setControlClimate(new ClimateInfo(temp, hum));
    }

    private float parseField(GuiTextField field) {
        String text = field.func_146179_b();
        if (text.isEmpty()) {
            return 2.0f;
        }
        try {
            float f = Float.parseFloat(text);
            if (f >= 2.0f) {
                f = 2.0f;
            }
            return f;
        }
        catch (NumberFormatException var5) {
            return 2.0f;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        if (this.fieldsEnabeled) {
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 29, 204, 115, 52, 12);
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 59, 204, 127, 52, 12);
            this.textLayout.line = 20;
            this.textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.temperature"), 0, ColourProperties.INSTANCE.get("gui.greenhouse.temperature.text"));
            this.temperatureField.func_146194_f();
            this.textLayout.line = 50;
            this.textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.humidity"), 0, ColourProperties.INSTANCE.get("gui.greenhouse.humidity.text"));
            this.humidityField.func_146194_f();
        }
    }

    @Override
    protected void addLedgers() {
        IGreenhouseControllerInternal greenhouseController = ((MultiblockLogicGreenhouse)this.tile.getMultiblockLogic()).getController();
        this.addErrorLedger(greenhouseController);
        this.ledgerManager.add(new EnergyLedger());
        this.addClimateLedger(greenhouseController);
        this.addHintLedger("greenhouse");
        this.addOwnerLedger(this.tile);
    }

    protected class EnergyLedger
    extends Ledger {
        public EnergyLedger() {
            super(GuiGreenhouse.this.ledgerManager, "power");
            this.maxHeight = 48;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawSprite(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
            this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 20);
            this.drawText(((MultiblockLogicGreenhouse)GuiGreenhouse.this.tile.getMultiblockLogic()).getController().getEnergyManager().getEnergyStored() + " RF", x + 22, y + 32);
        }

        @Override
        public String getTooltip() {
            return Translator.translateToLocal("for.gui.energy") + ": " + ((MultiblockLogicGreenhouse)GuiGreenhouse.this.tile.getMultiblockLogic()).getController().getEnergyManager().getEnergyStored() + " RF/t";
        }
    }
}

