/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.api.core.IToolPipette;
import forestry.core.fluids.PipetteContents;
import forestry.core.items.ItemForestry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation[] models;

    public ItemPipette() {
        this.func_77625_d(1);
        this.func_77664_n();
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = PipetteContents.create(itemstack);
        return contained == null || !contained.isFull();
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, player, list, flag);
        PipetteContents contained = PipetteContents.create(itemstack);
        if (contained != null) {
            contained.addTooltip(list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        this.models = new ModelResourceLocation[2];
        this.models[0] = manager.getModelLocation("pipette.0");
        this.models[1] = manager.getModelLocation("pipette.1");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:pipette.0")});
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:pipette.1")});
        manager.registerItemModel(item, new PipetteMeshDefinition());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 1000);
    }

    public class PipetteMeshDefinition
    implements ItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (FluidUtil.getFluidContained((ItemStack)stack) == null) {
                return ItemPipette.this.models[0];
            }
            return ItemPipette.this.models[1];
        }
    }
}

