/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class HintLedger
extends Ledger {
    private final String hintString;
    private final String hintTooltip;

    public HintLedger(LedgerManager manager, List<String> hints) {
        super(manager, "hint");
        int position = new Random().nextInt(hints.size());
        String hint = hints.get(position);
        this.hintString = Translator.translateToLocal("for.hints." + hint + ".desc");
        this.hintTooltip = Translator.translateToLocal("for.hints." + hint + ".tag");
        Minecraft minecraft = Proxies.common.getClientInstance();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int lineCount = fontRenderer.func_78271_c(this.hintString, this.maxTextWidth).size();
        this.maxHeight = (lineCount + 1) * fontRenderer.field_78288_b + 20;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawSprite(TextureManager.getInstance().getDefault("misc/hint"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(Translator.translateToLocal("for.gui.didyouknow") + '?', x + 22, y + 8);
        this.drawSplitText(this.hintString, x + 12, y + 20, this.maxTextWidth);
    }

    @Override
    public String getTooltip() {
        return this.hintTooltip;
    }
}

