/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.core.IItemModelRegister;
import forestry.core.CreativeTabForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.Log;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockForestry extends Block implements IItemModelRegister, ITileEntityProvider {

	protected BlockForestry(Material material) {
		super(material);
		func_149711_c(1.5f);
		func_149647_a(CreativeTabForestry.tabForestry);
	}

	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
		if (world.field_72995_K) {
			return;
		}

		if (placer instanceof EntityPlayer) {
			TileEntity tile = world.func_175625_s(pos);

			if (tile instanceof IOwnedTile) {
				IOwnerHandler ownerHandler = ((IOwnedTile) tile).getOwnerHandler();
				EntityPlayer player = (EntityPlayer) placer;
				GameProfile gameProfile = player.func_146103_bH();
				ownerHandler.setOwner(gameProfile);
			}
		}
	}

	@Override
	public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
		super.onNeighborChange(world, pos, neighbor);

		if (world instanceof World) {
			try {
				TileEntity tile = world.func_175625_s(pos);
				if (tile instanceof TileForestry) {
					((TileForestry) tile).onNeighborTileChange((World) world, pos, neighbor);
				}
			} catch (StackOverflowError error) {
				Log.error("Stack Overflow Error in BlockForestry.onNeighborChange()", error);
				throw error;
			}
		}
	}
}
