/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Genome;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TreeGenome
extends Genome
implements ITreeGenome {
    public TreeGenome(IChromosome[] chromosomes) {
        super(chromosomes);
    }

    public TreeGenome(NBTTagCompound nbttagcompound) {
        super(nbttagcompound);
    }

    public static IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        Preconditions.checkArgument((boolean)TreeManager.treeRoot.isMember(itemStack), (Object)"ItemStack must be a tree");
        IAlleleSpecies species = TreeGenome.getSpeciesDirectly(TreeManager.treeRoot, itemStack);
        if (species instanceof IAlleleTreeSpecies) {
            return (IAlleleTreeSpecies)species;
        }
        return (IAlleleTreeSpecies)TreeGenome.getActiveAllele(itemStack, EnumTreeChromosome.SPECIES, TreeManager.treeRoot);
    }

    @Override
    public IAlleleTreeSpecies getPrimary() {
        return (IAlleleTreeSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES);
    }

    @Override
    public IAlleleTreeSpecies getSecondary() {
        return (IAlleleTreeSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES);
    }

    @Override
    public IFruitProvider getFruitProvider() {
        return ((IAlleleFruit)this.getActiveAllele(EnumTreeChromosome.FRUITS)).getProvider();
    }

    @Override
    public float getHeight() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.HEIGHT)).getValue();
    }

    @Override
    public float getFertility() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.FERTILITY)).getValue();
    }

    @Override
    public float getYield() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.YIELD)).getValue();
    }

    @Override
    public float getSappiness() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.SAPPINESS)).getValue();
    }

    @Override
    public int getMaturationTime() {
        return ((IAlleleInteger)this.getActiveAllele(EnumTreeChromosome.MATURATION)).getValue();
    }

    @Override
    public int getGirth() {
        return ((IAlleleInteger)this.getActiveAllele(EnumTreeChromosome.GIRTH)).getValue();
    }

    @Override
    public IAlleleLeafEffect getEffect() {
        return (IAlleleLeafEffect)this.getActiveAllele(EnumTreeChromosome.EFFECT);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return TreeManager.treeRoot;
    }
}

