/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.models;

import javax.annotation.Nullable;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

public class ModelEscritoire extends ModelBase {

	//fields
	private final ModelRenderer desk;
	private final ModelRenderer standRB;
	private final ModelRenderer standRF;
	private final ModelRenderer standLB;
	private final ModelRenderer standLF;
	private final ModelRenderer drawers;
	private final ModelRenderer standLowLF;
	private final ModelRenderer standLowRB;
	private final ModelRenderer standLowRF;
	private final ModelRenderer standLowLB;

	public ModelEscritoire() {
		field_78090_t = 64;
		field_78089_u = 32;

		desk = new ModelRenderer(this, 0, 0);
		desk.func_78789_a(-8F, 3F, -7.8F, 16, 2, 15);
		desk.func_78793_a(0F, 0F, 0F);
		desk.func_78787_b(64, 32);
		desk.field_78809_i = true;
		setRotation(desk, 0.0872665f, 0f, 0f);
		standRB = new ModelRenderer(this, 38, 18);
		standRB.func_78789_a(5F, 4F, 5F, 2, 6, 2);
		standRB.func_78793_a(0F, 0F, 0F);
		standRB.func_78787_b(64, 32);
		standRB.field_78809_i = true;
		setRotation(standRB, 0F, 0F, 0F);
		standRF = new ModelRenderer(this, 38, 18);
		standRF.func_78789_a(5F, 4F, -7F, 2, 6, 2);
		standRF.func_78793_a(0F, 0F, 0F);
		standRF.func_78787_b(64, 32);
		standRF.field_78809_i = true;
		setRotation(standRF, 0F, 0F, 0F);
		standLB = new ModelRenderer(this, 38, 18);
		standLB.func_78789_a(-7F, 4F, 5F, 2, 6, 2);
		standLB.func_78793_a(0F, 0F, 0F);
		standLB.func_78787_b(64, 32);
		standLB.field_78809_i = true;
		setRotation(standLB, 0F, 0F, 0F);
		standLF = new ModelRenderer(this, 38, 18);
		standLF.func_78789_a(-7F, 4F, -7F, 2, 6, 2);
		standLF.func_78793_a(0F, 0F, 0F);
		standLF.func_78787_b(64, 32);
		standLF.field_78809_i = true;
		setRotation(standLF, 0F, 0F, 0F);
		drawers = new ModelRenderer(this, 0, 18);
		drawers.func_78789_a(-7.5F, -2F, 4.5F, 15, 5, 3);
		drawers.func_78793_a(0F, 0F, 0F);
		drawers.func_78787_b(64, 32);
		drawers.field_78809_i = true;
		setRotation(drawers, 0F, 0F, 0F);
		standLowLF = new ModelRenderer(this, 0, 26);
		standLowLF.func_78789_a(-6.5F, 10F, -6.5F, 1, 4, 1);
		standLowLF.func_78793_a(0F, 0F, 0F);
		standLowLF.func_78787_b(64, 32);
		standLowLF.field_78809_i = true;
		setRotation(standLowLF, 0F, 0F, 0F);
		standLowRB = new ModelRenderer(this, 0, 26);
		standLowRB.func_78789_a(5.5F, 10F, 5.5F, 1, 4, 1);
		standLowRB.func_78793_a(0F, 0F, 0F);
		standLowRB.func_78787_b(64, 32);
		standLowRB.field_78809_i = true;
		setRotation(standLowRB, 0F, 0F, 0F);
		standLowRF = new ModelRenderer(this, 0, 26);
		standLowRF.func_78789_a(5.5F, 10F, -6.5F, 1, 4, 1);
		standLowRF.func_78793_a(0F, 0F, 0F);
		standLowRF.func_78787_b(64, 32);
		standLowRF.field_78809_i = true;
		setRotation(standLowRF, 0F, 0F, 0F);
		standLowLB = new ModelRenderer(this, 0, 26);
		standLowLB.func_78789_a(-6.5F, 10F, 5.5F, 1, 4, 1);
		standLowLB.func_78793_a(0F, 0F, 0F);
		standLowLB.func_78787_b(64, 32);
		standLowLB.field_78809_i = true;
		setRotation(standLowLB, 0F, 0F, 0F);
		/*
		desk = new ModelRenderer(this, 0, 0);
		desk.addBox(0F, 0F, 0F, 16, 2, 15);
		desk.setRotationPoint(-8F, 4F, -7.5F);
		desk.setTextureSize(64, 32);
		desk.mirror = true;
		setRotation(desk, 0.0872665F, 0F, 0F);
		standRB = new ModelRenderer(this, 38, 18);
		standRB.addBox(0F, 0F, 0F, 2, 6, 2);
		standRB.setRotationPoint(5F, 4F, 5F);
		standRB.setTextureSize(64, 32);
		standRB.mirror = true;
		setRotation(standRB, 0F, 0F, 0F);
		standRF = new ModelRenderer(this, 38, 18);
		standRF.addBox(0F, 0F, 0F, 2, 6, 2);
		standRF.setRotationPoint(5F, 4F, -7F);
		standRF.setTextureSize(64, 32);
		standRF.mirror = true;
		setRotation(standRF, 0F, 0F, 0F);
		standLB = new ModelRenderer(this, 38, 18);
		standLB.addBox(0F, 0F, 0F, 2, 6, 2);
		standLB.setRotationPoint(-7F, 4F, 5F);
		standLB.setTextureSize(64, 32);
		standLB.mirror = true;
		setRotation(standLB, 0F, 0F, 0F);
		standLF = new ModelRenderer(this, 38, 18);
		standLF.addBox(0F, 0F, 0F, 2, 6, 2);
		standLF.setRotationPoint(-7F, 4F, -7F);
		standLF.setTextureSize(64, 32);
		standLF.mirror = true;
		setRotation(standLF, 0F, 0F, 0F);
		drawers = new ModelRenderer(this, 0, 18);
		drawers.addBox(0F, 0F, 0F, 16, 5, 3);
		drawers.setRotationPoint(-8F, -2F, 4.5F);
		drawers.setTextureSize(64, 32);
		drawers.mirror = true;
		setRotation(drawers, 0F, 0F, 0F);
		standLowLF = new ModelRenderer(this, 0, 25);
		standLowLF.addBox(0F, 0F, 0F, 1, 4, 1);
		standLowLF.setRotationPoint(-6.5F, 10F, -6.5F);
		standLowLF.setTextureSize(64, 32);
		standLowLF.mirror = true;
		setRotation(standLowLF, 0F, 0F, 0F);
		standLowRB = new ModelRenderer(this, 0, 25);
		standLowRB.addBox(0F, 0F, 0F, 1, 4, 1);
		standLowRB.setRotationPoint(5.5F, 10F, 5.5F);
		standLowRB.setTextureSize(64, 32);
		standLowRB.mirror = true;
		setRotation(standLowRB, 0F, 0F, 0F);
		standLowRF = new ModelRenderer(this, 0, 25);
		standLowRF.addBox(0F, 0F, 0F, 1, 4, 1);
		standLowRF.setRotationPoint(5.5F, 10F, -6.5F);
		standLowRF.setTextureSize(64, 32);
		standLowRF.mirror = true;
		setRotation(standLowRF, 0F, 0F, 0F);
		standLowLB = new ModelRenderer(this, 0, 25);
		standLowLB.addBox(0F, 0F, 0F, 1, 4, 1);
		standLowLB.setRotationPoint(-6.5F, 10F, 5.5F);
		standLowLB.setTextureSize(64, 32);
		standLowLB.mirror = true;
		setRotation(standLowLB, 0F, 0F, 0F);
		*/
	}

	@Override
	public void func_78088_a(@Nullable Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
		func_78087_a(f, f1, f2, f3, f4, f5, entity);
		desk.func_78785_a(f5);
		standRB.func_78785_a(f5);
		standRF.func_78785_a(f5);
		standLB.func_78785_a(f5);
		standLF.func_78785_a(f5);
		drawers.func_78785_a(f5);
		standLowLF.func_78785_a(f5);
		standLowRB.func_78785_a(f5);
		standLowRF.func_78785_a(f5);
		standLowLB.func_78785_a(f5);
	}

	private static void setRotation(ModelRenderer model, float x, float y, float z) {
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}

	@Override
	public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
		setRotation(desk, f + 0.0872665f, f1, f2);
		setRotation(standRB, f, f1, f2);
		setRotation(standRF, f, f1, f2);
		setRotation(standLB, f, f1, f2);
		setRotation(standLF, f, f1, f2);
		setRotation(drawers, f, f1, f2);
		setRotation(standLowLF, f, f1, f2);
		setRotation(standLowRB, f, f1, f2);
		setRotation(standLowRF, f, f1, f2);
		setRotation(standLowLB, f, f1, f2);
		super.func_78087_a(f, f1, f2, f3, f4, f5, entity);
	}

}
