/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.models;

import forestry.api.core.CamouflageManager;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflageItemHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IModelBaker;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockDefault;
import forestry.core.utils.CamouflageUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class ModelGreenhouse
extends ModelBlockDefault<BlockGreenhouse, Key> {
    public ModelGreenhouse() {
        super(BlockGreenhouse.class);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        return new Key(null, null, null);
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        IExtendedBlockState stateExtended = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        return new Key(stateExtended, world, pos);
    }

    @Override
    protected void bakeBlock(BlockGreenhouse block, Key key, IModelBaker baker, boolean inventory) {
        ItemStack camouflageStack = key.world != null ? CamouflageUtil.getCamouflageBlock(key.world, key.pos) : ItemStack.field_190927_a;
        IBlockAccess world = key.world;
        BlockPos pos = key.pos;
        if (!camouflageStack.func_190926_b()) {
            ICamouflageHandler camouflageHandler = CamouflageUtil.getCamouflageHandler(world, pos);
            ICamouflagedTile camouflageTile = (ICamouflagedTile)world.func_175625_s(pos);
            ICamouflageItemHandler itemHandler = CamouflageManager.camouflageAccess.getHandlerFromItem(camouflageStack);
            if (itemHandler != null && camouflageHandler != null && camouflageTile != null) {
                Pair<IBlockState, IBakedModel> model = itemHandler.getModel(camouflageStack, camouflageHandler, camouflageTile);
                baker.addBakedModel((IBlockState)model.getLeft(), (IBakedModel)model.getRight());
                baker.setParticleSprite(((IBakedModel)model.getRight()).func_177554_e());
            }
        } else if (block.getGreenhouseType() == BlockGreenhouseType.GLASS) {
            TextureAtlasSprite glassSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos);
            baker.addBlockModel(pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos), 100);
            baker.setParticleSprite(glassSprite);
        } else {
            TextureAtlasSprite plainSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos);
            baker.addBlockModel(pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos), 100);
            baker.setParticleSprite(plainSprite);
        }
        if (block.getGreenhouseType().hasOverlaySprite) {
            TextureAtlasSprite[] sprite = new TextureAtlasSprite[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                sprite[facing.ordinal()] = BlockGreenhouseType.getSprite(block.getGreenhouseType(), facing, (IBlockState)key.state, world, pos);
            }
            baker.addBlockModel(pos, sprite, 101);
        }
    }

    public static class Key {
        @Nullable
        public final IExtendedBlockState state;
        @Nullable
        public final IBlockAccess world;
        @Nullable
        public final BlockPos pos;

        public Key(@Nullable IExtendedBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
            this.state = state;
            this.world = world;
            this.pos = pos;
        }
    }
}

