/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.TileUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public final class AdjacentInventoryCache
implements AdjacentTileCache.ICacheListener {
    private final AdjacentTileCache cache;
    private boolean changed = true;
    private final List<IItemHandler> invs = new LinkedList<IItemHandler>();
    private final IItemHandler[] sides = new IItemHandler[6];
    @Nullable
    private final Comparator<IItemHandler> sorter;
    @Nullable
    private final ITileFilter filter;

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache) {
        this(tile, cache, null, null);
    }

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache, @Nullable ITileFilter filter) {
        this(tile, cache, filter, null);
    }

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache, @Nullable ITileFilter filter, @Nullable Comparator<IItemHandler> sorter) {
        this.cache = cache;
        this.filter = filter;
        this.sorter = sorter;
        cache.addListener(this);
    }

    public IItemHandler getAdjacentInventory(EnumFacing side) {
        this.checkChanged();
        return this.sides[side.ordinal()];
    }

    public Collection<IItemHandler> getAdjacentInventories() {
        this.checkChanged();
        return this.invs;
    }

    @Override
    public void changed() {
        this.changed = true;
    }

    @Override
    public void purge() {
        this.invs.clear();
        Arrays.fill(this.sides, null);
    }

    private void checkChanged() {
        this.cache.refresh();
        if (this.changed) {
            this.changed = false;
            this.purge();
            for (EnumFacing side : EnumFacing.values()) {
                IItemHandler inv;
                TileEntity tile = this.cache.getTileOnSide(side);
                if (tile == null || this.filter != null && !this.filter.matches(tile) || (inv = TileUtil.getInventoryFromTile(tile, side.func_176734_d())) == null) continue;
                this.sides[side.ordinal()] = inv;
                this.invs.add(inv);
            }
            if (this.sorter != null) {
                this.invs.sort(this.sorter);
            }
        }
    }

    public static interface ITileFilter {
        public boolean matches(TileEntity var1);
    }
}

