/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockCharcoal;
import forestry.core.CreativeTabForestry;
import forestry.core.proxy.Proxies;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWoodPile
extends Block
implements IItemModelRegister,
IStateMapperRegister {
    public static final PropertyBool IS_ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final int RANDOM_TICK = 40;

    public BlockWoodPile() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabForestry.tabForestry);
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_ACTIVE, AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_ACTIVE) != false ? 8 + (Integer)state.func_177229_b((IProperty)AGE) : (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = meta > 7;
        return this.func_176223_P().func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta - (isActive ? 8 : 0)));
    }

    public int func_149738_a(World world) {
        return 40;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IBlockState facingState = world.func_180495_p(pos.func_177972_a(facing));
                if (facingState.func_177230_c() != this || !((Boolean)facingState.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) continue;
                world.func_175656_a(pos, state.func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                break;
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(40));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState fromState = world.func_180495_p(fromPos);
        boolean isActive = (Boolean)state.func_177229_b((IProperty)IS_ACTIVE);
        if (fromState.func_177230_c() == this) {
            if (((Boolean)fromState.func_177229_b((IProperty)IS_ACTIVE)).booleanValue() && !isActive) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(40));
            }
        } else if (fromState.func_177230_c() == Blocks.field_150480_ab && !isActive) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(40));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (world.func_175623_d(pos.func_177972_a(facing))) {
                    world.func_175656_a(pos.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P());
                }
                if (rand.nextInt(150) == 0) {
                    if ((Integer)state.func_177229_b((IProperty)AGE) < 7) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
                    } else {
                        world.func_175656_a(pos, PluginArboriculture.getBlocks().charcoal.func_176223_P().func_177226_a((IProperty)BlockCharcoal.AMOUNT, (Comparable)Integer.valueOf(Math.round(this.getCharcoalAmount(world, pos)))));
                    }
                }
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(40));
            }
        }
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 12;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 25;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            return 10;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (rand.nextInt(12) == 0) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.05, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0);
    }

    public float getCharcoalAmount(World world, BlockPos pos) {
        float charcoalAmount = 0.0f;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            charcoalAmount += (float)this.getCharcoalFaceAmount(world, pos, facing);
        }
        return charcoalAmount / 6.0f;
    }

    private int getCharcoalFaceAmount(World world, BlockPos pos, EnumFacing facing) {
        int faceAmount = 0;
        block0: for (int i = 0; i < 18; ++i) {
            BlockPos testPos = pos.func_177967_a(facing, i);
            IBlockState state = world.func_180495_p(testPos);
            if (state.func_177230_c() == Blocks.field_150350_a) {
                faceAmount = 0;
                break;
            }
            if (state.func_177230_c() == this || state.func_177230_c() == PluginArboriculture.getBlocks().charcoal) {
                if (i != 17) continue;
                return this.getCharcoalFaceAmount(world, testPos, facing);
            }
            for (ICharcoalPileWall wall : TreeManager.pileWalls) {
                if (!wall.matches(state)) continue;
                faceAmount = wall.getCharcoalAmount();
                break block0;
            }
            break;
        }
        return Math.max(1, faceAmount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper(this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AGE, IS_ACTIVE}).func_178441_a());
    }
}

