/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.proxy.Proxies;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.network.packets.PacketWorktableRecipeUpdate;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketWorktableRecipeRequest
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final MemorizedRecipe recipe;

    public PacketWorktableRecipeRequest(TileWorktable worktable, MemorizedRecipe recipe) {
        this.pos = worktable.func_174877_v();
        this.recipe = recipe;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.WORKTABLE_RECIPE_REQUEST;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        this.recipe.writeData(data);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            BlockPos pos = data.func_179259_c();
            MemorizedRecipe recipe = new MemorizedRecipe(data);
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile instanceof TileWorktable) {
                TileWorktable worktable = (TileWorktable)tile;
                worktable.setCurrentRecipe(recipe);
                if (player.field_71070_bA instanceof ContainerWorktable) {
                    ContainerWorktable containerWorktable = (ContainerWorktable)player.field_71070_bA;
                    containerWorktable.updateCraftMatrix();
                }
                Proxies.net.sendNetworkPacket(new PacketWorktableRecipeUpdate(worktable), pos, player.field_70170_p);
            }
        }
    }
}

