/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.widgets.ClearWorktable;
import forestry.factory.gui.widgets.MemorizedRecipeSlot;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiWorktable
extends GuiForestryTitled<ContainerWorktable> {
    private static final int SPACING = 18;
    private final TileWorktable tile;
    private boolean hasRecipeConflict = false;

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable2.png", new ContainerWorktable(player, tile), tile);
        this.tile = tile;
        this.field_147000_g = 218;
        RecipeMemory recipeMemory = tile.getMemory();
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                MemorizedRecipeSlot memorizedRecipeSlot = new MemorizedRecipeSlot(this.widgetManager, xPos, yPos, recipeMemory, slot++);
                this.widgetManager.add(memorizedRecipeSlot);
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.hasRecipeConflict != this.tile.hasRecipeConflict()) {
            this.hasRecipeConflict = this.tile.hasRecipeConflict();
            if (this.hasRecipeConflict) {
                this.addButtons();
            } else {
                this.field_146292_n.clear();
            }
        }
    }

    private void addButtons() {
        this.field_146292_n.add(new GuiBetterButton(0, this.field_147003_i + 76, this.field_147009_r + 56, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.field_146292_n.add(new GuiBetterButton(1, this.field_147003_i + 85, this.field_147009_r + 56, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    protected void func_146284_a(GuiButton button) {
        int id = 100 + button.field_146127_k;
        Proxies.net.sendToServer(new PacketGuiSelectRequest(id, 0));
        Proxies.common.playButtonClick();
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addHintLedger("worktable");
    }
}

