/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.authlib.GameProfile;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.TextureManager;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class OwnerLedger
extends Ledger {
    @Nullable
    private final GameProfile owner;

    public OwnerLedger(LedgerManager manager, IOwnedTile tile) {
        super(manager, "owner");
        this.owner = tile.getOwnerHandler().getOwner();
        this.maxHeight = 40;
    }

    @Override
    public boolean isVisible() {
        return this.owner != null;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        TextureAtlasSprite accessIcon = TextureManager.getInstance().getDefault("misc/access.shared");
        this.drawSprite(accessIcon, x + 3, y + 4);
        if (this.isFullyOpened()) {
            this.drawHeader(Translator.translateToLocal("for.gui.owner"), x + 22, y + 8);
            this.drawText(PlayerUtil.getOwnerName(this.owner), x + 22, y + 20);
        }
    }

    @Override
    public String getTooltip() {
        return Translator.translateToLocal("for.gui.owner") + ": " + PlayerUtil.getOwnerName(this.owner);
    }
}

