/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.ForestryAPI;
import forestry.core.circuits.ISocketable;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.utils.ItemStackUtil;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;

public abstract class InventoryUtil {
    public static boolean isWildcard(ItemStack stack) {
        return stack.func_77952_i() == Short.MAX_VALUE;
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InventoryUtil.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchNBT && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (InventoryUtil.isWildcard(a) || InventoryUtil.isWildcard(b)) {
                return true;
            }
            if (a.func_77952_i() != b.func_77952_i()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InventoryUtil.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack stack, Collection<ItemStack> matches) {
        for (ItemStack match : matches) {
            if (!InventoryUtil.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean moveItemStack(IItemHandler source, IItemHandler dest) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(source);
        return manipulator.transferOneStack(dest, StandardStackFilters.ALL);
    }

    public static boolean moveItemStack(IItemHandler source, Iterable<IItemHandler> destinations) {
        for (IItemHandler dest : destinations) {
            if (!InventoryUtil.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static boolean moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache) {
        return InventoryUtil.moveOneItemToPipe(source, tileCache, EnumFacing.values());
    }

    public static boolean moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache, EnumFacing[] directions) {
        if (ForestryAPI.enabledPlugins.contains("forestry.buildcraft.transport")) {
            return InventoryUtil.internal_moveOneItemToPipe(source, tileCache, directions);
        }
        return false;
    }

    @Optional.Method(modid="BuildCraftAPI|transport")
    private static boolean internal_moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache, EnumFacing[] directions) {
        return false;
    }

    public static boolean removeSets(IInventory inventory, int count, NonNullList<ItemStack> set, @Nullable EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools, boolean doRemove) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (doRemove) {
            NonNullList<ItemStack> removed = InventoryUtil.removeSets(inventory, count, set, player, stowContainer, oreDictionary, craftingTools);
            return removed != null && removed.size() >= count;
        }
        return ItemStackUtil.containsSets(set, stock, oreDictionary, craftingTools) >= count;
    }

    @Nullable
    public static NonNullList<ItemStack> removeSets(IInventory inventory, int count, NonNullList<ItemStack> set, @Nullable EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        NonNullList removed = NonNullList.func_191197_a((int)set.size(), (Object)ItemStack.field_190927_a);
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (ItemStackUtil.containsSets(set, stock, oreDictionary, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.size(); ++i) {
            ItemStack itemStack = (ItemStack)set.get(i);
            if (itemStack.func_190926_b()) continue;
            ItemStack stackToRemove = itemStack.func_77946_l();
            stackToRemove.func_190920_e(stackToRemove.func_190916_E() * count);
            ItemStack removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, false, false);
            if (removedStack.func_190926_b()) {
                removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, oreDictionary, craftingTools);
            }
            removed.set(i, (Object)removedStack);
        }
        return removed;
    }

    private static ItemStack removeStack(IInventory inventory, ItemStack stackToRemove, @Nullable EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stackInSlot = inventory.func_70301_a(j);
            if (stackInSlot.func_190926_b() || !ItemStackUtil.isCraftingEquivalent(stackToRemove, stackInSlot, oreDictionary, craftingTools)) continue;
            ItemStack removed = inventory.func_70298_a(j, stackToRemove.func_190916_E());
            stackToRemove.func_190918_g(removed.func_190916_E());
            if (stowContainer && stackToRemove.func_77973_b().hasContainerItem(stackToRemove)) {
                InventoryUtil.stowContainerItem(removed, inventory, j, player);
            }
            if (!stackToRemove.func_190926_b()) continue;
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean contains(IInventory inventory, NonNullList<ItemStack> query) {
        return InventoryUtil.contains(inventory, query, 0, inventory.func_70302_i_());
    }

    public static boolean contains(IInventory inventory, NonNullList<ItemStack> query, int startSlot, int slots) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory, startSlot, slots);
        return ItemStackUtil.containsSets(query, stock) > 0;
    }

    public static boolean containsPercent(IInventory inventory, float percent) {
        return InventoryUtil.containsPercent(inventory, percent, 0, inventory.func_70302_i_());
    }

    public static boolean containsPercent(IInventory inventory, float percent, int slot1, int length) {
        int amount = 0;
        int stackMax = 0;
        for (ItemStack itemStack : InventoryUtil.getStacks(inventory, slot1, length)) {
            if (itemStack == null) {
                stackMax += 64;
                continue;
            }
            amount += itemStack.func_190916_E();
            stackMax += itemStack.func_77976_d();
        }
        if (stackMax == 0) {
            return false;
        }
        return (float)amount / (float)stackMax >= percent;
    }

    public static boolean isEmpty(IInventory inventory, int slotStart, int slotCount) {
        for (int i = slotStart; i < slotStart + slotCount; ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<ItemStack> getStacks(IInventory inventory) {
        NonNullList stacks = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks.set(i, (Object)inventory.func_70301_a(i));
        }
        return stacks;
    }

    public static NonNullList<ItemStack> getStacks(IInventory inventory, int slot1, int length) {
        NonNullList result = NonNullList.func_191197_a((int)length, (Object)ItemStack.field_190927_a);
        for (int i = slot1; i < slot1 + length; ++i) {
            result.set(i - slot1, (Object)inventory.func_70301_a(i));
        }
        return result;
    }

    public static boolean tryAddStacksCopy(IInventory inventory, NonNullList<ItemStack> stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || InventoryUtil.tryAddStack(inventory, stack.func_77946_l(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, doAdd);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        boolean success;
        int added = InventoryUtil.addStack(inventory, stack, startSlot, slots, false);
        boolean bl = all ? added == stack.func_190916_E() : (success = added > 0);
        if (success && doAdd) {
            InventoryUtil.addStack(inventory, stack, startSlot, slots, true);
        }
        return success;
    }

    public static int addStack(IInventory inventory, ItemStack stack, boolean doAdd) {
        return InventoryUtil.addStack(inventory, stack, 0, inventory.func_70302_i_(), doAdd);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        if (stack.func_190926_b()) {
            return 0;
        }
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack.func_190926_b() || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.func_190916_E() - added;
            int space = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.func_190917_f(remain);
                }
                return stack.func_190916_E();
            }
            if (doAdd) {
                inventoryStack.func_190920_e(inventoryStack.func_77976_d());
            }
            added += space;
        }
        if (added >= stack.func_190916_E()) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            if (doAdd) {
                inventory.func_70299_a(i, stack.func_77946_l());
                inventory.func_70301_a(i).func_190920_e(stack.func_190916_E() - added);
            }
            return stack.func_190916_E();
        }
        return added;
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return InventoryUtil.stowInInventory(itemstack, inventory, doAdd, 0, inventory.func_70302_i_());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack.func_190926_b()) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                    itemstack.func_190920_e(0);
                }
                return true;
            }
            if (inventoryStack.func_190916_E() >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
            if (space > itemstack.func_190916_E()) {
                if (doAdd) {
                    inventoryStack.func_190917_f(itemstack.func_190916_E());
                    itemstack.func_190920_e(0);
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.func_190920_e(inventoryStack.func_77976_d());
                itemstack.func_190918_g(space);
            }
            added = true;
        }
        return added;
    }

    public static void stowContainerItem(ItemStack itemstack, IInventory stowing, int slotIndex, @Nullable EntityPlayer player) {
        if (!itemstack.func_77973_b().hasContainerItem(itemstack)) {
            return;
        }
        ItemStack container = ForgeHooks.getContainerItem((ItemStack)itemstack);
        if (!(container.func_190926_b() || InventoryUtil.tryAddStack(stowing, container, slotIndex, 1, true) || InventoryUtil.tryAddStack(stowing, container, true) || player == null)) {
            player.func_71019_a(container, true);
        }
    }

    public static void deepCopyInventoryContents(IInventory source, IInventory destination) {
        if (source.func_70302_i_() != destination.func_70302_i_()) {
            throw new IllegalArgumentException("Inventory sizes do not match. Source: " + source + ", Destination: " + destination);
        }
        for (int i = 0; i < source.func_70302_i_(); ++i) {
            ItemStack stack = source.func_70301_a(i);
            if (!stack.func_190926_b()) {
                stack = stack.func_77946_l();
            }
            destination.func_70299_a(i, stack);
        }
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemstack = inventory.func_70301_a(slot);
            InventoryUtil.dropItemStackFromInventory(itemstack, world, x, y, z);
            inventory.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public static void dropInventory(IInventory inventory, World world, BlockPos pos) {
        InventoryUtil.dropInventory(inventory, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void dropSockets(ISocketable socketable, World world, double x, double y, double z) {
        for (int slot = 0; slot < socketable.getSocketCount(); ++slot) {
            ItemStack itemstack = socketable.getSocket(slot);
            InventoryUtil.dropItemStackFromInventory(itemstack, world, x, y, z);
            socketable.setSocket(slot, ItemStack.field_190927_a);
        }
    }

    public static void dropSockets(ISocketable socketable, World world, BlockPos pos) {
        InventoryUtil.dropSockets(socketable, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void dropItemStackFromInventory(ItemStack itemStack, World world, double x, double y, double z) {
        if (itemStack.func_190926_b()) {
            return;
        }
        float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        while (!itemStack.func_190926_b()) {
            int stackPartial = world.field_73012_v.nextInt(21) + 10;
            if (stackPartial > itemStack.func_190916_E()) {
                stackPartial = itemStack.func_190916_E();
            }
            ItemStack drop = itemStack.func_77979_a(stackPartial);
            EntityItem entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, drop);
            float accel = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * accel;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * accel + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * accel;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void readFromNBT(IInventory inventory, NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.func_74764_b(inventory.func_70005_c_())) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(inventory.func_70005_c_(), 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            byte index = nbttagcompound2.func_74771_c("Slot");
            inventory.func_70299_a((int)index, new ItemStack(nbttagcompound2));
        }
    }

    public static void writeToNBT(IInventory inventory, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Slot", (byte)i);
            inventory.func_70301_a(i).func_77955_b(nbttagcompound2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound.func_74782_a(inventory.func_70005_c_(), (NBTBase)nbttaglist);
    }
}

