/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BottlerRecipe {
    public final FluidStack fluid;
    public final ItemStack inputStack;
    public final ItemStack outputStack;
    public final boolean fillRecipe;

    @Nullable
    public static BottlerRecipe createEmptyingRecipe(ItemStack filled) {
        ItemStack empty = filled.func_77946_l();
        empty.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack drained = fluidHandler.drain(Integer.MAX_VALUE, true);
        if (drained != null && drained.amount > 0) {
            return new BottlerRecipe(fluidHandler.getContainer(), drained, filled, false);
        }
        return null;
    }

    @Nullable
    public static BottlerRecipe createFillingRecipe(Fluid res, ItemStack empty) {
        ItemStack filled = empty.func_77946_l();
        filled.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (fluidHandler == null) {
            return null;
        }
        int fillAmount = fluidHandler.fill(new FluidStack(res, Integer.MAX_VALUE), true);
        if (fillAmount > 0) {
            return new BottlerRecipe(empty, new FluidStack(res, fillAmount), fluidHandler.getContainer(), true);
        }
        return null;
    }

    public BottlerRecipe(ItemStack inputStack, FluidStack fluid, ItemStack outputStack, boolean fillRecipe) {
        this.fluid = fluid;
        this.inputStack = inputStack;
        this.outputStack = outputStack;
        this.fillRecipe = fillRecipe;
    }

    public boolean matchEmpty(ItemStack emptyCan, FluidStack resource) {
        return emptyCan.func_190926_b() && emptyCan.func_77969_a(this.inputStack) && resource.isFluidEqual(this.fluid) && this.fillRecipe;
    }

    public boolean matchFilled(ItemStack filledCan) {
        return !this.outputStack.func_190926_b() && !this.fillRecipe && this.outputStack.func_77969_a(filledCan);
    }
}

