/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketFXSignal
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final VisualFXType visualFX;
    private final SoundFXType soundFX;
    private final IBlockState blockState;

    public PacketFXSignal(VisualFXType type, BlockPos pos, IBlockState blockState) {
        this(type, SoundFXType.NONE, pos, blockState);
    }

    public PacketFXSignal(SoundFXType type, BlockPos pos, IBlockState blockState) {
        this(VisualFXType.NONE, type, pos, blockState);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, BlockPos pos, IBlockState blockState) {
        this.pos = pos;
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.blockState = blockState;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeByte(this.visualFX.ordinal());
        data.writeByte(this.soundFX.ordinal());
        Block block = this.blockState.func_177230_c();
        data.func_150787_b(Block.func_149682_b((Block)block));
        data.func_150787_b(block.func_176201_c(this.blockState));
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.FX_SIGNAL;
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            VisualFXType visualFX = VisualFXType.values()[data.readByte()];
            SoundFXType soundFX = SoundFXType.values()[data.readByte()];
            Block block = Block.func_149729_e((int)data.func_150792_a());
            IBlockState blockState = block.func_176203_a(data.func_150792_a());
            World world = player.field_70170_p;
            if (visualFX == VisualFXType.BLOCK_BREAK) {
                Proxies.common.addBlockDestroyEffects(world, pos, blockState);
            }
            if (soundFX != SoundFXType.NONE) {
                SoundType soundType = block.getSoundType(blockState, world, pos, null);
                if (soundFX == SoundFXType.BLOCK_BREAK) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                } else if (soundFX == SoundFXType.BLOCK_PLACE) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                }
            }
        }
    }

    public static enum SoundFXType {
        NONE,
        BLOCK_BREAK,
        BLOCK_PLACE;

    }

    public static enum VisualFXType {
        NONE,
        BLOCK_BREAK,
        SAPLING_PLACE;

    }
}

