/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.core.IModelBaker;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockCached;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelLeaves
extends ModelBlockCached<BlockForestryLeaves, Key> {
    @Override
    protected Key getInventoryKey(ItemStack itemStack) {
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        TileLeaves leaves = new TileLeaves();
        if (itemStack.func_77978_p() != null) {
            leaves.func_145839_a(itemStack.func_77978_p());
        } else {
            leaves.setTree(TreeRoot.treeTemplates.get(0));
        }
        boolean fancy = Proxies.render.fancyGraphicsEnabled();
        ResourceLocation leafLocation = leaves.getLeaveSprite(fancy);
        ResourceLocation fruitLocation = leaves.getFruitSprite();
        return new Key(map.func_110572_b(leafLocation.toString()), fruitLocation != null ? map.func_110572_b(fruitLocation.toString()) : null, fancy);
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        IExtendedBlockState stateExtended = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        TileLeaves tile = TileUtil.getTile(world, pos, TileLeaves.class);
        boolean fancy = Proxies.render.fancyGraphicsEnabled();
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        if (tile == null) {
            IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.getIndividual().getGenome().getPrimary();
            ResourceLocation spriteLocation = oakSpecies.getLeafSpriteProvider().getSprite(false, fancy);
            TextureAtlasSprite sprite = map.func_110572_b(spriteLocation.toString());
            return new Key(sprite, null, fancy);
        }
        ResourceLocation leafLocation = tile.getLeaveSprite(fancy);
        ResourceLocation fruitLocation = tile.getFruitSprite();
        return new Key(map.func_110572_b(leafLocation.toString()), fruitLocation != null ? map.func_110572_b(fruitLocation.toString()) : null, fancy);
    }

    @Override
    protected void bakeBlock(BlockForestryLeaves block, Key key, IModelBaker baker, boolean inventory) {
        baker.addBlockModel(null, key.leafSprite, 0);
        if (key.fruitSprite != null) {
            baker.addBlockModel(null, key.fruitSprite, 1);
        }
        baker.setParticleSprite(key.leafSprite);
    }

    public ModelLeaves() {
        super(BlockForestryLeaves.class);
    }

    public static class Key {
        public final TextureAtlasSprite leafSprite;
        @Nullable
        public final TextureAtlasSprite fruitSprite;
        public final boolean fancy;
        private final int hashCode;

        public Key(TextureAtlasSprite leafSprite, @Nullable TextureAtlasSprite fruitSprite, boolean fancy) {
            this.leafSprite = leafSprite;
            this.fruitSprite = fruitSprite;
            this.fancy = fancy;
            this.hashCode = Objects.hash(leafSprite, fruitSprite, fancy);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.leafSprite == this.leafSprite && otherKey.fruitSprite == this.fruitSprite && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

