/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.factory.tiles;

import javax.annotation.Nullable;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileMill;
import forestry.factory.inventory.InventoryRainmaker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;

public class TileMillRainmaker extends TileMill {
	private int duration;
	private boolean reverse;

	public TileMillRainmaker() {
		speed = 0.01f;
		setInternalInventory(new InventoryRainmaker(this));
	}

	@Override
	public void openGui(EntityPlayer player, ItemStack heldItem) {
		if (!player.field_70170_p.field_72995_K && !heldItem.func_190926_b()) {
			// We don't have a gui, but we can be activated
			if (FuelManager.rainSubstrate.containsKey(heldItem) && charge == 0) {
				RainSubstrate substrate = FuelManager.rainSubstrate.get(heldItem);
				if (substrate.getItem().func_77969_a(heldItem)) {
					addCharge(substrate);
					heldItem.func_190918_g(1);
				}
			}
			sendNetworkUpdate();
		}
	}

	@Override
	public void func_145839_a(NBTTagCompound nbttagcompound) {
		super.func_145839_a(nbttagcompound);

		charge = nbttagcompound.func_74762_e("Charge");
		progress = nbttagcompound.func_74760_g("Progress");
		stage = nbttagcompound.func_74762_e("Stage");
		duration = nbttagcompound.func_74762_e("Duration");
		reverse = nbttagcompound.func_74767_n("Reverse");
	}


	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
		nbttagcompound = super.func_189515_b(nbttagcompound);

		nbttagcompound.func_74768_a("Charge", charge);
		nbttagcompound.func_74776_a("Progress", progress);
		nbttagcompound.func_74768_a("Stage", stage);
		nbttagcompound.func_74768_a("Duration", duration);
		nbttagcompound.func_74757_a("Reverse", reverse);
		return nbttagcompound;
	}

	public void addCharge(RainSubstrate substrate) {
		charge = 1;
		speed = substrate.getSpeed();
		duration = substrate.getDuration();
		reverse = substrate.isReverse();
		sendNetworkUpdate();
	}

	@Override
	public void activate() {
		if (Proxies.render.hasRendering()) {
			field_145850_b.func_184133_a(null, func_174877_v(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0F, 0.8F + field_145850_b.field_73012_v.nextFloat() * 0.2F);

			float f = func_174877_v().func_177958_n() + 0.5F;
			float f1 = func_174877_v().func_177956_o() + 0.0F + field_145850_b.field_73012_v.nextFloat() * 6F / 16F;
			float f2 = func_174877_v().func_177952_p() + 0.5F;
			float f3 = 0.52F;
			float f4 = field_145850_b.field_73012_v.nextFloat() * 0.6F - 0.3F;

			Proxies.render.addEntityExplodeFX(field_145850_b, f - f3, f1, f2 + f4);
			Proxies.render.addEntityExplodeFX(field_145850_b, f + f3, f1, f2 + f4);
			Proxies.render.addEntityExplodeFX(field_145850_b, f + f4, f1, f2 - f3);
			Proxies.render.addEntityExplodeFX(field_145850_b, f + f4, f1, f2 + f3);
		}

		if (!field_145850_b.field_72995_K) {
			if (reverse) {
				field_145850_b.func_72912_H().func_76084_b(false);
			} else {
				field_145850_b.func_72912_H().func_76084_b(true);
				field_145850_b.func_72912_H().func_76080_g(duration);
			}
			charge = 0;
			duration = 0;
			reverse = false;
			sendNetworkUpdate();
		}
	}

	@Override
	@Nullable
	public Object getGui(EntityPlayer player, int data) {
		return null;
	}

	@Override
	@Nullable
	public Object getContainer(EntityPlayer player, int data) {
		return null;
	}
}
