/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumLeafType;
import forestry.core.proxy.Proxies;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class TextureLeaves {
    private static final Map<EnumLeafType, TextureLeaves> leafTextures = new EnumMap<EnumLeafType, TextureLeaves>(EnumLeafType.class);
    private final ResourceLocation plain;
    private final ResourceLocation fancy;
    private final ResourceLocation pollinatedPlain;
    private final ResourceLocation pollinatedFancy;

    public static TextureLeaves get(EnumLeafType leafType) {
        return leafTextures.get((Object)leafType);
    }

    public static void registerAllSprites() {
        for (TextureLeaves leafTexture : leafTextures.values()) {
            leafTexture.registerSprites();
        }
    }

    private TextureLeaves(EnumLeafType enumLeafType) {
        String ident = enumLeafType.toString().toLowerCase(Locale.ENGLISH);
        this.plain = new ResourceLocation("forestry", "blocks/leaves/" + ident + ".plain");
        this.fancy = new ResourceLocation("forestry", "blocks/leaves/" + ident + ".fancy");
        this.pollinatedPlain = new ResourceLocation("forestry", "blocks/leaves/" + ident + ".changed.plain");
        this.pollinatedFancy = new ResourceLocation("forestry", "blocks/leaves/" + ident + ".changed");
    }

    private void registerSprites() {
        TextureMap textureMapBlocks = Proxies.common.getClientInstance().func_147117_R();
        textureMapBlocks.func_174942_a(this.plain);
        textureMapBlocks.func_174942_a(this.fancy);
        textureMapBlocks.func_174942_a(this.pollinatedPlain);
        textureMapBlocks.func_174942_a(this.pollinatedFancy);
    }

    public ResourceLocation getSprite(boolean pollinated, boolean fancy) {
        if (pollinated) {
            if (fancy) {
                return this.pollinatedFancy;
            }
            return this.pollinatedPlain;
        }
        if (fancy) {
            return this.fancy;
        }
        return this.plain;
    }

    static {
        for (EnumLeafType leafType : EnumLeafType.values()) {
            leafTextures.put(leafType, new TextureLeaves(leafType));
        }
    }
}

