/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.storage;

import java.util.ArrayList;
import java.util.List;

import forestry.api.storage.BackpackResupplyEvent;
import forestry.core.IResupplyHandler;
import forestry.core.inventory.ItemInventory;
import forestry.storage.inventory.ItemInventoryBackpack;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ResupplyHandler implements IResupplyHandler {

	private static List<ItemStack> backpacks(InventoryPlayer playerInventory) {
		List<ItemStack> backpacks = new ArrayList<>();
		for (ItemStack itemStack : playerInventory.field_70462_a) {
			if (itemStack.func_77973_b() instanceof ItemBackpack) {
				backpacks.add(itemStack);
			}
		}
		return backpacks;
	}

	@Override
	public void resupply(EntityPlayer player) {

		// Do not attempt resupplying if this backpack is already opened.
		if (!(player.field_71070_bA instanceof ContainerPlayer)) {
			return;
		}

		for (ItemStack backpack : backpacks(player.field_71071_by)) {

			// Only handle those in resupply mode
			if (ItemBackpack.getMode(backpack) != BackpackMode.RESUPPLY) {
				continue;
			}

			// Delay before resupplying
			if (backpack.func_77952_i() < 40) {
				backpack.func_77964_b(backpack.func_77952_i() + 1);
				continue;
			}

			// Load their inventory
			ItemBackpack backpackItem = (ItemBackpack) backpack.func_77973_b();
			ItemInventory backpackInventory = new ItemInventoryBackpack(player, backpackItem.getBackpackSize(), backpack);

			Event event = new BackpackResupplyEvent(player, backpackItem.getDefinition(), backpackInventory);
			MinecraftForge.EVENT_BUS.post(event);
			if (event.isCanceled()) {
				continue;
			}

			// Cycle through their contents
			for (int i = 0; i < backpackInventory.func_70302_i_(); i++) {

				ItemStack itemStack = backpackInventory.func_70301_a(i);
				if (itemStack.func_190926_b()) {
					continue;
				}

				// Try to add it to the player's inventory and note any change
				boolean change = topOffPlayerInventory(player, itemStack);

				if (change) {
					backpackInventory.func_70299_a(i, itemStack);
				}
			}
		}
	}

	/**
	 * This tops off existing stacks in the player's inventory.
	 */
	private static boolean topOffPlayerInventory(EntityPlayer player, ItemStack itemstack) {

		// Add to player inventory first, if there is an incomplete stack in
		// there.
		for (int i = 0; i < player.field_71071_by.func_70302_i_(); i++) {
			ItemStack inventoryStack = player.field_71071_by.func_70301_a(i);
			// We only add to existing stacks.
			if (inventoryStack.func_190926_b()) {
				continue;
			}

			// Already full
			if (inventoryStack.func_190916_E() >= inventoryStack.func_77976_d()) {
				continue;
			}

			if (inventoryStack.func_77969_a(itemstack) && ItemStack.func_77970_a(inventoryStack, itemstack)) {
				inventoryStack.func_190917_f(1);
				itemstack.func_190918_g(1);
				return true;
			}
		}
		return false;

	}

}
