/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectServer;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ITitled;
import forestry.core.utils.ItemStackUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseDoor;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.GuiGreenhouse;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileGreenhouse
extends MultiblockTileEntityForestry<MultiblockLogicGreenhouse>
implements IGreenhouseComponent,
IStreamableGui,
IErrorLogicSource,
IOwnedTile,
ITitled,
ICamouflageHandler,
ICamouflagedTile {
    protected ItemStack camouflageBlock = ItemStack.field_190927_a;

    protected TileGreenhouse() {
        super(new MultiblockLogicGreenhouse());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (newSate.func_177230_c() instanceof BlockGreenhouseDoor && oldState.func_177230_c() instanceof BlockGreenhouseDoor) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
    }

    @Override
    public void onMachineBroken() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("CamouflageBlock")) {
            this.camouflageBlock = new ItemStack(data.func_74775_l("CamouflageBlock"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
        return data;
    }

    @Override
    public boolean setCamouflageBlock(String type, ItemStack camouflageBlock, boolean sendClientUpdate) {
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)) {
            this.camouflageBlock = camouflageBlock;
            if (sendClientUpdate && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                Proxies.net.sendToServer(new PacketCamouflageSelectServer(this, type, CamouflageSelectionType.TILE));
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandleType(String type) {
        return type.equals(this.getCamouflageType());
    }

    @Override
    public ItemStack getCamouflageBlock(String type) {
        return this.camouflageBlock;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(String type) {
        return ItemStack.field_190927_a;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            packetData.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("CamouflageBlock")) {
            this.setCamouflageBlock(this.getCamouflageType(), new ItemStack(packetData.func_74775_l("CamouflageBlock")), true);
        }
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getOwnerHandler();
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.greenhouse.title";
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiGreenhouse(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerGreenhouse(player.field_71071_by, this);
    }

    @Override
    public String getCamouflageType() {
        if (this.func_145838_q() instanceof BlockGreenhouse && ((BlockGreenhouse)this.func_145838_q()).getGreenhouseType() == BlockGreenhouseType.GLASS) {
            return "glass";
        }
        if (((BlockGreenhouse)this.func_145838_q()).getGreenhouseType() == BlockGreenhouseType.DOOR) {
            return "door";
        }
        return "block";
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getInternalInventory();
    }
}

