/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.api.food.BeverageManager;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.recipes.RecipeUtil;
import forestry.food.BeverageEffects;
import forestry.food.InfuserIngredientManager;
import forestry.food.InfuserMixtureManager;
import forestry.food.items.ItemRegistryFood;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

@ForestryPlugin(pluginID="forestry.food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.food.description")
public class PluginFood
extends BlankForestryPlugin {
    @Nullable
    private static ItemRegistryFood items;

    public static ItemRegistryFood getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    @Override
    public void setupAPI() {
        super.setupAPI();
        BeverageManager.infuserManager = new InfuserMixtureManager();
        BeverageManager.ingredientManager = new InfuserIngredientManager();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryFood();
    }

    @Override
    public void preInit() {
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            ItemRegistryApiculture beeItems = PluginApiculture.getItems();
            ItemStack normalPollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.NORMAL, 1);
            ItemStack crystallinePollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1);
            BeverageManager.ingredientManager.addIngredient(normalPollenCluster, "Strong Curative");
            BeverageManager.ingredientManager.addIngredient(crystallinePollenCluster, "Weak Curative");
            BeverageManager.infuserManager.addMixture(1, normalPollenCluster, BeverageEffects.strongAntidote);
            BeverageManager.infuserManager.addMixture(1, crystallinePollenCluster, BeverageEffects.weakAntidote);
        }
    }

    @Override
    public void registerRecipes() {
        RecipeUtil.addRecipe(PluginFood.getItems().infuser.getItemStack(), "X", "#", "X", Character.valueOf('#'), "ingotIron", Character.valueOf('X'), "ingotBronze");
    }
}

