/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import forestry.api.core.ForestryAPI;
import forestry.core.EventHandlerCore;
import forestry.core.climate.ClimateEventHandler;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.GameMode;
import forestry.core.errors.EnumErrorCode;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.gui.GuiHandler;
import forestry.core.multiblock.MultiblockEventHandler;
import forestry.core.network.PacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.MigrationHelper;
import forestry.core.worldgen.WorldGenerator;
import forestry.plugins.PluginManager;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="forestry", name="Forestry", version="5.3.0.27", guiFactory="forestry.core.config.ForestryGuiConfigFactory", acceptedMinecraftVersions="[1.11]", dependencies="required-after:forge@[13.19.1.2189,);after:JEI@[4.1.1,);")
public class Forestry {
    @Mod.Instance(value="forestry")
    public static Forestry instance;
    @Nullable
    private File configFolder;
    @Nullable
    private static PacketHandler packetHandler;

    public Forestry() {
        ForestryAPI.instance = this;
        ForestryAPI.forestryConstants = new Constants();
        ForestryAPI.errorStateRegistry = new ErrorStateRegistry();
        EnumErrorCode.init();
        FluidRegistry.enableUniversalBucket();
    }

    public static PacketHandler getPacketHandler() {
        Preconditions.checkState((packetHandler != null ? 1 : 0) != 0);
        return packetHandler;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        EventHandlerCore eventHandlerCore = new EventHandlerCore();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerCore);
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClimateEventHandler());
        Proxies.common.registerEventHandlers();
        this.configFolder = new File(event.getModConfigurationDirectory(), "forestry");
        Config.load();
        PluginManager.runSetup(event);
        String gameMode = Config.gameMode;
        Preconditions.checkState((gameMode != null ? 1 : 0) != 0);
        ForestryAPI.activeMode = new GameMode(gameMode);
        PluginManager.runPreInit();
        Proxies.render.registerModels();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        PluginManager.runInit();
        Proxies.render.registerItemAndBlockColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PluginManager.runPostInit();
        WorldGenerator worldGenerator = new WorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)0);
        Proxies.common.registerTickHandlers(worldGenerator);
        PluginManager.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        PluginManager.serverStarting(event.getServer());
    }

    @Nullable
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        PluginManager.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        MigrationHelper.onMissingMappings(event);
    }
}

