/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.EnumDeliveryState;
import forestry.mail.PostRegistry;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.gui.GuiMailbox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileMailbox
extends TileBase {
    public TileMailbox() {
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player, ItemStack heldItem) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (PostManager.postRegistry.isLetter(heldItem)) {
            IPostalState result = this.tryDispatchLetter(heldItem);
            if (!result.isOk()) {
                player.func_145747_a((ITextComponent)new TextComponentString(result.getDescription()));
            } else {
                heldItem.func_190918_g(1);
            }
        } else {
            super.openGui(player, heldItem);
        }
    }

    public IInventory getOrCreateMailInventory(World world, GameProfile playerProfile) {
        if (world.field_72995_K) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox(world, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterStack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterStack);
        IPostalState result = letter != null ? PostManager.postRegistry.getPostOffice(this.field_145850_b).lodgeLetter(this.field_145850_b, letterStack, true) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiMailbox(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerMailbox(player.field_71071_by, this);
    }
}

