/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.GuiUtil;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GameTokenWidget
extends Widget {
    private final ItemStack HIDDEN_TOKEN = new ItemStack(Items.field_151122_aG);
    private final EscritoireGame game;
    private final int index;

    public GameTokenWidget(EscritoireGame game, WidgetManager manager, int xPos, int yPos, int index) {
        super(manager, xPos, yPos);
        this.game = game;
        this.index = index;
    }

    @Nullable
    private EscritoireGameToken getToken() {
        return this.game.getToken(this.index);
    }

    @Override
    public void draw(int startX, int startY) {
        EscritoireGameToken token = this.getToken();
        if (token == null) {
            return;
        }
        int tokenColour = token.getTokenColour();
        float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(tokenColour & 0xFF) / 255.0f;
        Proxies.render.bindTexture(this.manager.gui.textureFile);
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)colorR, (float)colorG, (float)colorB);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tokenStack = this.HIDDEN_TOKEN;
        if (token.isVisible()) {
            tokenStack = token.getTokenStack();
        }
        GuiUtil.drawItemStack(this.manager.gui, tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
        GlStateManager.func_179097_i();
        for (String ident : this.getToken().getOverlayIcons()) {
            TextureManager textureManager = TextureManager.getInstance();
            Proxies.render.bindTexture(textureManager.getGuiTextureMap());
            TextureAtlasSprite icon = textureManager.getDefault(ident);
            this.manager.gui.func_175175_a(startX + this.xPos + 3, startY + this.yPos + 3, icon, 16, 16);
        }
        GlStateManager.func_179126_j();
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        EscritoireGameToken token = this.getToken();
        if (token == null || !token.isVisible()) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(token.getTooltip());
        return tooltip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.game.choose(this.index);
        Proxies.net.sendToServer(new PacketGuiSelectRequest(this.index, 0));
        Proxies.common.playButtonClick();
    }
}

