/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.food.BeverageEffect;
import forestry.food.InfuserMixture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InfuserMixtureManager
implements IInfuserManager {
    private final List<InfuserMixture> mixtures = new ArrayList<InfuserMixture>();

    @Override
    public void addMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)ingredient);
        this.mixtures.add(new InfuserMixture(meta, (NonNullList<ItemStack>)ingredients, effect));
    }

    @Override
    public void addMixture(int meta, NonNullList<ItemStack> ingredients, IBeverageEffect effect) {
        this.mixtures.add(new InfuserMixture(meta, ingredients, effect));
    }

    @Override
    public boolean isIngredient(ItemStack itemstack) {
        for (InfuserMixture ingredient : this.mixtures) {
            if (!ingredient.isIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    private List<InfuserMixture> getMatchingMixtures(NonNullList<ItemStack> ingredients) {
        ArrayList<InfuserMixture> matches = new ArrayList<InfuserMixture>();
        for (InfuserMixture mixture : this.mixtures) {
            if (!mixture.matches(ingredients)) continue;
            matches.add(mixture);
        }
        return matches;
    }

    @Override
    public boolean hasMixtures(NonNullList<ItemStack> ingredients) {
        return !this.getMatchingMixtures(ingredients).isEmpty();
    }

    @Override
    public NonNullList<ItemStack> getRequired(NonNullList<ItemStack> ingredients) {
        List<InfuserMixture> mixtures = this.getMatchingMixtures(ingredients);
        NonNullList required = NonNullList.func_191196_a();
        for (InfuserMixture mixture : mixtures) {
            required.addAll(mixture.getIngredients());
        }
        return required;
    }

    @Override
    public ItemStack getSeasoned(ItemStack base, NonNullList<ItemStack> ingredients) {
        List<InfuserMixture> mixtures = this.getMatchingMixtures(ingredients);
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(base);
        int weight = 0;
        int meta = 0;
        for (InfuserMixture mixture : mixtures) {
            effects.add(mixture.getEffect());
            if (mixture.getWeight() <= weight) continue;
            weight = mixture.getWeight();
            meta = mixture.getMeta();
        }
        ItemStack seasoned = base.func_77946_l();
        seasoned.func_77964_b(meta);
        BeverageEffect.saveEffects(seasoned, effects);
        return seasoned;
    }
}

