/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.IColoredBlock;
import forestry.core.items.IColoredItem;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelEntry;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ModelUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManager
implements IModelManager {
    private static final ModelManager instance = new ModelManager();
    private final List<BlockModelEntry> customBlockModels = new ArrayList<BlockModelEntry>();
    private final List<ModelEntry> customModels = new ArrayList<ModelEntry>();
    private final List<IItemModelRegister> itemModelRegisters = new ArrayList<IItemModelRegister>();
    private final List<IStateMapperRegister> stateMapperRegisters = new ArrayList<IStateMapperRegister>();
    private final List<IColoredBlock> blockColorList = new ArrayList<IColoredBlock>();
    private final List<IColoredItem> itemColorList = new ArrayList<IColoredItem>();
    private IModelState defaultBlockState;
    private IModelState defaultItemState;

    public static ModelManager getInstance() {
        return instance;
    }

    @Override
    public void registerItemModel(Item item, int meta, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(identifier));
    }

    @Override
    public void registerItemModel(Item item, int meta, String modID, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(modID, identifier));
    }

    @Override
    public void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(item));
    }

    @Override
    public void registerItemModel(Item item, ItemMeshDefinition definition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }

    @Override
    public ModelResourceLocation getModelLocation(Item item) {
        ResourceLocation resourceLocation = ItemStackUtil.getItemNameFromRegistry(item);
        Preconditions.checkNotNull((Object)resourceLocation);
        String itemName = resourceLocation.func_110623_a();
        return this.getModelLocation(itemName);
    }

    @Override
    public ModelResourceLocation getModelLocation(String identifier) {
        return this.getModelLocation("forestry", identifier);
    }

    @Override
    public ModelResourceLocation getModelLocation(String modID, String identifier) {
        return new ModelResourceLocation(modID + ":" + identifier, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockClient(Block block) {
        if (block instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)block);
        }
        if (block instanceof IStateMapperRegister) {
            this.stateMapperRegisters.add((IStateMapperRegister)block);
        }
        if (block instanceof IColoredBlock) {
            this.blockColorList.add((IColoredBlock)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemClient(Item item) {
        if (item instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)item);
        }
        if (item instanceof IColoredItem) {
            this.itemColorList.add((IColoredItem)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IItemModelRegister itemModelRegister : this.itemModelRegisters) {
            Item item = null;
            if (itemModelRegister instanceof Block) {
                item = Item.func_150898_a((Block)((Block)itemModelRegister));
            } else if (itemModelRegister instanceof Item) {
                item = (Item)itemModelRegister;
            }
            if (item == null) continue;
            itemModelRegister.registerModel(item, this);
        }
        for (IStateMapperRegister stateMapperRegister : this.stateMapperRegisters) {
            stateMapperRegister.registerStateMapper();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemAndBlockColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : this.blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : this.itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_186730_a((IItemColor)ColoredItemItemColor.INSTANCE, new Item[]{(Item)itemColor});
        }
    }

    public IModelState getDefaultBlockState() {
        return this.defaultBlockState;
    }

    public IModelState getDefaultItemState() {
        return this.defaultItemState;
    }

    public void registerCustomBlockModel(BlockModelEntry index) {
        this.customBlockModels.add(index);
    }

    public void registerCustomModel(ModelEntry index) {
        this.customModels.add(index);
    }

    public void onBakeModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (BlockModelEntry blockModelEntry : this.customBlockModels) {
            registry.func_82595_a((Object)blockModelEntry.blockModelLocation, (Object)blockModelEntry.model);
            if (blockModelEntry.itemModelLocation == null) continue;
            registry.func_82595_a((Object)blockModelEntry.itemModelLocation, (Object)blockModelEntry.model);
        }
        for (ModelEntry modelEntry : this.customModels) {
            registry.func_82595_a((Object)modelEntry.modelLocation, (Object)modelEntry.model);
        }
        this.defaultItemState = ModelUtil.loadModelState(new ResourceLocation("minecraft:models/item/generated"));
        this.defaultBlockState = ModelUtil.loadModelState(new ResourceLocation("minecraft:models/block/block"));
    }

    static {
        ForestryAPI.modelManager = instance;
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock && worldIn != null && pos != null) {
                return ((IColoredBlock)block).colorMultiplier(state, worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredItemItemColor
    implements IItemColor {
        public static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemstack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

