/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.ICrateRegistry;
import forestry.core.items.ItemCrated;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.MigrationHelper;
import forestry.storage.PluginStorage;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class CrateRegistry
implements ICrateRegistry {
    private static void registerCrate(ItemStack stack, @Nullable String oreDictName) {
        String crateName;
        if (stack.func_190926_b()) {
            Log.error("Tried to make a crate without an item", new Object[0]);
            return;
        }
        if (oreDictName != null) {
            crateName = "crated." + oreDictName;
        } else {
            String stringForItemStack = ItemStackUtil.getStringForItemStack(stack);
            if (stringForItemStack == null) {
                Log.error("Could not get string name for itemStack {}", stack);
                return;
            }
            String itemName = stringForItemStack.replace(':', '.');
            crateName = "crated." + itemName;
        }
        ItemCrated crate = new ItemCrated(stack, oreDictName);
        crate.func_77655_b(crateName);
        crate.setRegistryName(crateName);
        MigrationHelper.addItemName(crateName);
        GameRegistry.register((IForgeRegistryEntry)crate);
        Proxies.common.registerItem(crate);
        PluginStorage.registerCrate(crate);
    }

    @Override
    public void registerCrate(String oreDictName) {
        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
            for (ItemStack stack : OreDictionary.getOres((String)oreDictName)) {
                if (stack == null) continue;
                CrateRegistry.registerCrate(stack, oreDictName);
                break;
            }
        }
    }

    @Override
    public void registerCrate(Block block) {
        CrateRegistry.registerCrate(new ItemStack(block), null);
    }

    @Override
    public void registerCrate(Item item) {
        CrateRegistry.registerCrate(new ItemStack(item), null);
    }

    @Override
    public void registerCrate(ItemStack stack) {
        CrateRegistry.registerCrate(stack, null);
    }
}

