/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import forestry.core.TickHandlerCoreClient;
import forestry.core.models.ModelManager;
import forestry.core.multiblock.MultiblockClientTickHandler;
import forestry.core.multiblock.MultiblockEventHandlerClient;
import forestry.core.proxy.ProxyCommon;
import forestry.core.render.TextureManager;
import forestry.core.worldgen.WorldGenerator;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class ProxyClient
extends ProxyCommon {
    @Override
    public void registerTickHandlers(WorldGenerator worldGenerator) {
        super.registerTickHandlers(worldGenerator);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerCoreClient());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockClientTickHandler());
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandlerClient());
    }

    @Override
    public void registerBlock(Block block) {
        ModelManager.getInstance().registerBlockClient(block);
        TextureManager.getInstance().registerBlock(block);
    }

    @Override
    public void registerItem(Item item) {
        ModelManager.getInstance().registerItemClient(item);
        TextureManager.getInstance().registerItem(item);
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().field_71441_e;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().field_71442_b.func_78757_d();
        }
        return 4.0;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.func_77973_b().func_77653_i(itemstack);
    }

    @Override
    public void addBlockDestroyEffects(World world, BlockPos pos, IBlockState blockState) {
        Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, blockState);
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void playButtonClick() {
        Minecraft minecraft = this.getClientInstance();
        SoundHandler soundHandler = minecraft.func_147118_V();
        soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

