/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.VectUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AlleleEffectSnowing
extends AlleleEffectThrottled {
    public AlleleEffectSnowing() {
        super("snowing", false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vec3i area = AlleleEffectSnowing.getModifiedArea(genome, housing);
        BlockPos offset = VectUtil.scale(area, -0.5f);
        for (int i = 0; i < 1; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);
            BlockPos posBlock = randomPos.func_177971_a((Vec3i)housing.getCoordinates()).func_177971_a((Vec3i)offset);
            if (!world.func_175667_e(posBlock) || !world.isSideSolid(posBlock.func_177977_b(), EnumFacing.UP, false)) continue;
            IBlockState state = world.func_180495_p(posBlock);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150431_aC) {
                Integer layers = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                if (layers < 7) {
                    IBlockState moreSnow = state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layers + 1));
                    world.func_175656_a(posBlock, moreSnow);
                    continue;
                }
                world.func_175656_a(posBlock, Blocks.field_150433_aE.func_176223_P());
                continue;
            }
            if (!block.func_176200_f((IBlockAccess)world, posBlock)) continue;
            world.func_175656_a(posBlock, Blocks.field_150431_aC.func_176223_P());
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorldObj().field_73012_v.nextInt(3) == 0) {
            Vec3i area = AlleleEffectSnowing.getModifiedArea(genome, housing);
            BlockPos offset = VectUtil.scale(area, -0.5f);
            BlockPos coordinates = housing.getCoordinates();
            World world = housing.getWorldObj();
            BlockPos spawn = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vec3i)coordinates).func_177971_a((Vec3i)offset);
            Proxies.render.addEntitySnowFX(world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

