/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food.inventory;

import forestry.api.food.BeverageManager;
import forestry.core.inventory.ItemInventory;
import forestry.food.PluginFood;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemInventoryInfuser extends ItemInventory {
	private static final short inputSlot = 0;
	private static final short outputSlot = 1;
	private static final short ingredientSlot1 = 2;
	private static final short ingredientSlotCount = 4;

	public ItemInventoryInfuser(EntityPlayer player, ItemStack itemStack) {
		super(player, 6, itemStack);
	}

	@Override
	public void onSlotClick(int slotIndex, EntityPlayer player) {

		// Need input
		ItemStack input = func_70301_a(inputSlot);
		if (!input.func_190926_b() &&
				func_70301_a(outputSlot).func_190926_b() &&
				PluginFood.getItems().beverage == input.func_77973_b()) {

			// Create the seasoned item
			NonNullList<ItemStack> ingredients = NonNullList.func_191196_a();
			for (int i = 0; i < ingredientSlotCount; i++) {
				ingredients.add(func_70301_a(i + ingredientSlot1));
			}

			// Only continue if there is anything to season
			if (BeverageManager.infuserManager.hasMixtures(ingredients)) {

				ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(input, ingredients);
				if (!seasoned.func_190926_b()) {

					// Remove required ingredients.
					NonNullList<ItemStack> toRemove = BeverageManager.infuserManager.getRequired(ingredients);
					for (ItemStack templ : toRemove) {
						ItemStack ghost = templ.func_77946_l();

						for (int i = ingredientSlot1; i < this.func_70302_i_() && !ghost.func_190926_b(); i++) {
							ItemStack ingredient = func_70301_a(i);
							if (!ingredient.func_190926_b() && OreDictionary.itemMatches(ghost, ingredient, false)) {
								ItemStack removed = func_70298_a(i, 1);
								ghost.func_190918_g(removed.func_190916_E());
							}
						}
					}
					func_70298_a(inputSlot, 1);
					func_70299_a(outputSlot, seasoned);
				}
			}
		}
	}


	@Override
	public String func_70005_c_() {
		return "Infuser";
	}

	@Override
	public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		if (slotIndex == inputSlot) {
			return PluginFood.getItems().beverage == itemStack.func_77973_b();
		} else if (slotIndex >= ingredientSlot1 && slotIndex < ingredientSlot1 + ingredientSlotCount) {
			return BeverageManager.infuserManager.isIngredient(itemStack);
		}
		return false;
	}
}
