/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockController;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.utils.Log;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MultiblockEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onChunkLoad(ChunkEvent.Load loadEvent) {
        Chunk chunk = loadEvent.getChunk();
        World world = loadEvent.getWorld();
        MultiblockRegistry.onChunkLoaded(world, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldUnload(WorldEvent.Unload unloadWorldEvent) {
        MultiblockRegistry.onWorldUnloaded(unloadWorldEvent.getWorld());
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        try {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Set<IMultiblockControllerInternal> controllers = MultiblockRegistry.getControllersFromWorld((World)world);
            if (!controllers.isEmpty()) {
                float partialTicks = event.getPartialTicks();
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179090_x();
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179132_a((boolean)false);
                for (IMultiblockController iMultiblockController : controllers) {
                    BlockPos lastErrorPosition;
                    if (iMultiblockController == null || (lastErrorPosition = iMultiblockController.getLastValidationErrorPosition()) == null || !world.func_175667_e(lastErrorPosition) || !(player.func_174818_b(lastErrorPosition) < 64.0)) continue;
                    AxisAlignedBB box = Block.field_185505_j.func_72317_d((double)lastErrorPosition.func_177958_n() - playerX, (double)lastErrorPosition.func_177956_o() - playerY, (double)lastErrorPosition.func_177952_p() - playerZ);
                    RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.25f);
                    RenderGlobal.func_189696_b((AxisAlignedBB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.125f);
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
        catch (Exception e) {
            Log.error("Failed to render the position of a multiblock exeption.", e);
        }
    }
}

