/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.multiblock.ICharcoalPileComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.multiblock.EnumPilePosition;
import forestry.arboriculture.multiblock.MultiblockLogicCharcoalPile;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.tiles.TileUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePile
extends MultiblockTileEntityForestry<MultiblockLogicCharcoalPile>
implements ICharcoalPileComponent<MultiblockLogicCharcoalPile> {
    @Nullable
    private IAlleleTreeSpecies treeSpecies;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private BlockPos woodPos;

    public TilePile() {
        super(new MultiblockLogicCharcoalPile());
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
        if (this.getPileType() != EnumPileType.ASH) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.updateState(), 2);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        Block newBlock = newState.func_177230_c();
        return oldState.func_177230_c() != newBlock && newBlock != PluginArboriculture.getBlocks().piles.get((Object)EnumPileType.ASH);
    }

    @Override
    public void onMachineBroken() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            this.woodPos = null;
        }
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
        this.func_70296_d();
        if (this.getPileType() != EnumPileType.ASH) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.updateState(), 2);
        }
    }

    private IBlockState updateState() {
        TilePile pile = TileUtil.getTile((IBlockAccess)this.field_145850_b, this.field_174879_c, TilePile.class);
        EnumPilePosition pileType = EnumPilePosition.INTERIOR;
        if (pile != null && ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).isConnected() && ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).getController().isAssembled()) {
            BlockPos maxCoord = ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).getController().getMaximumCoord();
            BlockPos minCoord = ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).getController().getMinimumCoord();
            int level = this.field_174879_c.func_177956_o() - minCoord.func_177956_o();
            int levelMinX = minCoord.func_177958_n() + level;
            int levelMinY = minCoord.func_177956_o() + level;
            int levelMinZ = minCoord.func_177952_p() + level;
            int levelMaxX = maxCoord.func_177958_n() - level;
            int levelMaxY = maxCoord.func_177956_o() - level;
            int levelMaxZ = maxCoord.func_177952_p() - level;
            int facesMatching = 0;
            if (levelMaxX == this.field_174879_c.func_177958_n() || levelMinX == this.field_174879_c.func_177958_n()) {
                ++facesMatching;
            }
            if (levelMaxZ == this.field_174879_c.func_177952_p() || levelMinZ == this.field_174879_c.func_177952_p()) {
                ++facesMatching;
            }
            if (facesMatching > 0) {
                if (levelMaxX == this.field_174879_c.func_177958_n()) {
                    pileType = levelMaxZ == this.field_174879_c.func_177952_p() ? EnumPilePosition.CORNER_BACK_RIGHT : (levelMinZ == this.field_174879_c.func_177952_p() ? EnumPilePosition.CORNER_FRONT_RIGHT : EnumPilePosition.SIDE_RIGHT);
                } else if (levelMinX == this.field_174879_c.func_177958_n()) {
                    pileType = levelMaxZ == this.field_174879_c.func_177952_p() ? EnumPilePosition.CORNER_BACK_LEFT : (levelMinZ == this.field_174879_c.func_177952_p() ? EnumPilePosition.CORNER_FRONT_LEFT : EnumPilePosition.SIDE_LEFT);
                } else if (levelMaxZ == this.field_174879_c.func_177952_p()) {
                    pileType = levelMaxX == this.field_174879_c.func_177958_n() ? EnumPilePosition.CORNER_FRONT_RIGHT : (levelMinX == this.field_174879_c.func_177958_n() ? EnumPilePosition.CORNER_FRONT_LEFT : EnumPilePosition.FRONT);
                } else if (levelMinZ == this.field_174879_c.func_177952_p()) {
                    pileType = levelMaxX == this.field_174879_c.func_177958_n() ? EnumPilePosition.CORNER_BACK_RIGHT : (levelMinX == this.field_174879_c.func_177958_n() ? EnumPilePosition.CORNER_BACK_LEFT : EnumPilePosition.BACK);
                }
            }
        }
        return this.func_145838_q().func_176223_P().func_177226_a(BlockPile.PILE_POSITION, (Comparable)((Object)pileType));
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        String treeSpeciesUid;
        IAllele allele;
        super.func_145839_a(data);
        if (data.func_74764_b("ContainedTree")) {
            Tree containedTree = new Tree(data.func_74775_l("ContainedTree"));
            this.setTreeSpecies(containedTree.getGenome().getPrimary());
        }
        if (data.func_74764_b("TreeSpecies") && (allele = AlleleManager.alleleRegistry.getAllele(treeSpeciesUid = data.func_74779_i("TreeSpecies"))) instanceof IAlleleTreeSpecies) {
            IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies)allele;
            this.setTreeSpecies(treeSpecies);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (this.treeSpecies != null) {
            data.func_74778_a("TreeSpecies", this.treeSpecies.getUID());
        }
        return data;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        if (this.treeSpecies != null) {
            packetData.func_74778_a("TreeSpecies", this.treeSpecies.getUID());
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        String treeSpeciesUid;
        IAllele allele;
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("TreeSpecies") && (allele = AlleleManager.alleleRegistry.getAllele(treeSpeciesUid = packetData.func_74779_i("TreeSpecies"))) instanceof IAlleleTreeSpecies) {
            IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies)allele;
            this.setTreeSpecies(treeSpecies);
        }
    }

    @Override
    public void setTreeSpecies(IAlleleTreeSpecies treeSpecies) {
        this.treeSpecies = treeSpecies;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public IAlleleTreeSpecies getTreeSpecies() {
        return this.treeSpecies;
    }

    @Override
    public EnumPileType getPileType() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return ((BlockPile)state.func_177230_c()).getPileType();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IAlleleTreeSpecies getNextWoodPile() {
        TilePile pile;
        if (this.woodPos == null) {
            this.woodPos = this.getNextWoodPilePos();
        }
        if ((pile = TileUtil.getTile((IBlockAccess)this.field_145850_b, this.woodPos, TilePile.class)) != null) {
            return pile.getTreeSpecies();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private BlockPos getNextWoodPilePos() {
        EnumPilePosition pilePos = (EnumPilePosition)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPile.PILE_POSITION));
        int layer = this.field_174879_c.func_177956_o() - ((MultiblockLogicCharcoalPile)this.getMultiblockLogic()).getController().getMinimumCoord().func_177956_o();
        Block woodPile = PluginArboriculture.getBlocks().piles.get((Object)EnumPileType.WOOD);
        switch (pilePos) {
            case BACK: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, 1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(0, 0, 1);
            }
            case FRONT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, -1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(0, 0, -1);
            }
            case SIDE_LEFT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 0, 0));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(1, 0, 0);
            }
            case SIDE_RIGHT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 0, 0));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(-1, 0, 0);
            }
            case CORNER_FRONT_LEFT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 0, 1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(1, 0, 1);
            }
            case CORNER_FRONT_RIGHT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 0, 1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(-1, 0, 1);
            }
            case CORNER_BACK_LEFT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 0, -1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(1, 0, -1);
            }
            case CORNER_BACK_RIGHT: {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 0, -1));
                if (state.func_177230_c() != woodPile) {
                    return this.field_174879_c.func_177982_a(0, -1, 0);
                }
                return this.field_174879_c.func_177982_a(-1, 0, -1);
            }
        }
        return this.field_174879_c.func_177982_a(0, -1, 0);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return null;
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return null;
    }
}

