/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.collect.Maps;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodStateMapper;
import forestry.api.arboriculture.IWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.PropertyWoodType;
import forestry.arboriculture.models.WoodModelLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WoodTypeStateMapper
extends StateMapperBase
implements IWoodStateMapper {
    private final IWoodTyped woodTyped;
    private final String blockPath;
    @Nullable
    private final PropertyWoodType<?> propertyWoodType;
    private final List<IProperty> propertiesToRemove = new ArrayList<IProperty>();

    public WoodTypeStateMapper(IWoodTyped woodTyped, @Nullable PropertyWoodType<?> propertyWoodType) {
        this.woodTyped = woodTyped;
        this.blockPath = woodTyped.getBlockKind().toString();
        this.propertyWoodType = propertyWoodType;
    }

    public WoodTypeStateMapper(IWoodTyped woodTyped, String blockPath, @Nullable PropertyWoodType<?> propertyWoodType) {
        this.woodTyped = woodTyped;
        this.blockPath = blockPath;
        this.propertyWoodType = propertyWoodType;
    }

    public WoodTypeStateMapper addPropertyToRemove(IProperty property) {
        this.propertiesToRemove.add(property);
        return this;
    }

    @Override
    public ModelResourceLocation getModelLocation(IBlockState state) {
        return this.func_178132_a(state);
    }

    protected ModelResourceLocation func_178132_a(IBlockState state) {
        LinkedHashMap properties;
        if (this.propertyWoodType != null) {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
            properties.remove(this.propertyWoodType);
        } else {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
        }
        for (IProperty property : this.propertiesToRemove) {
            properties.remove(property);
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        IWoodType woodType = this.woodTyped.getWoodType(meta);
        if (woodType instanceof EnumForestryWoodType) {
            if (WoodModelLoader.INSTANCE.isRegistered) {
                return this.getForestryModelResourceLocation(woodType, properties);
            }
            return this.getDefaultModelResourceLocation(state);
        }
        return this.getVanillaModelResourceLocation(block, woodType, properties);
    }

    @Override
    public ModelResourceLocation getDefaultModelResourceLocation(IBlockState state) {
        LinkedHashMap properties;
        if (this.propertyWoodType != null) {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
            properties.remove(this.propertyWoodType);
        } else {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
        }
        for (IProperty property : this.propertiesToRemove) {
            properties.remove(property);
        }
        String resourceLocation = "arboriculture/" + this.blockPath;
        String propertyString = this.func_178131_a(properties);
        return new ModelResourceLocation("forestry:" + resourceLocation, propertyString);
    }

    private ModelResourceLocation getForestryModelResourceLocation(IWoodType woodType, Map<IProperty<?>, Comparable<?>> properties) {
        String resourceLocation = "arboriculture/" + this.blockPath + '/' + woodType;
        String propertyString = this.func_178131_a(properties);
        return new ModelResourceLocation("forestry:" + resourceLocation, propertyString);
    }

    private ModelResourceLocation getVanillaModelResourceLocation(Block block, IWoodType woodType, Map<IProperty<?>, Comparable<?>> properties) {
        String resourceLocation = woodType == EnumVanillaWoodType.OAK && (block instanceof BlockFenceGate || block instanceof BlockFence) ? this.blockPath : woodType + "_" + this.blockPath;
        String propertyString = this.func_178131_a(properties);
        return new ModelResourceLocation("minecraft:" + resourceLocation, propertyString);
    }
}

