/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.collect.Lists;
import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.ITextureManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.multiblock.ICharcoalPileComponent;
import forestry.apiculture.blocks.BlockCandle;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.multiblock.EnumPilePosition;
import forestry.arboriculture.multiblock.ICharcoalPileControllerInternal;
import forestry.arboriculture.multiblock.MultiblockLogicCharcoalPile;
import forestry.arboriculture.render.PileParticleCallback;
import forestry.arboriculture.render.PileStateMapper;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockStructure;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.proxy.Proxies;
import forestry.core.render.ParticleHelper;
import forestry.core.tiles.TileUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockPile
extends BlockStructure
implements ITileEntityProvider,
IStateMapperRegister,
ISpriteRegister {
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final PropertyEnum<EnumPilePosition> PILE_POSITION = PropertyEnum.func_177709_a((String)"position", EnumPilePosition.class);
    public final ParticleHelper.Callback particleCallback;
    private long previousMessageTick = 0L;
    private final ThreadLocal<List<ItemStack>> drop = new ThreadLocal();

    public static Map<EnumPileType, BlockPile> create() {
        EnumMap<EnumPileType, BlockPile> blockMap = new EnumMap<EnumPileType, BlockPile>(EnumPileType.class);
        for (final EnumPileType type : EnumPileType.VALUES) {
            BlockPile pile = new BlockPile(){

                public String getHarvestTool(IBlockState state) {
                    if (type == EnumPileType.WOOD) {
                        return "axe";
                    }
                    return "shovel";
                }

                public int getHarvestLevel(IBlockState state) {
                    return 0;
                }

                @Override
                public EnumPileType getPileType() {
                    return type;
                }

                public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
                    if (type == EnumPileType.DIRT) {
                        return Blocks.field_150346_d.getSoundType(state, world, pos, entity);
                    }
                    if (type == EnumPileType.ASH) {
                        return Blocks.field_150354_m.getSoundType(state, world, pos, entity);
                    }
                    if (type == EnumPileType.WOOD) {
                        return Blocks.field_150364_r.getSoundType(state, world, pos, entity);
                    }
                    return super.getSoundType(state, world, pos, entity);
                }
            };
            blockMap.put(type, pile);
        }
        return blockMap;
    }

    public BlockPile() {
        super(Material.field_151578_c);
        this.func_149711_c(1.0f);
        this.func_149663_c("charcoal.pile");
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PILE_POSITION, (Comparable)((Object)EnumPilePosition.INTERIOR)));
        this.particleCallback = new PileParticleCallback(this);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PILE_POSITION}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockPile.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockPile.getCollisionBoxList(state)) {
            BlockPile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumPilePosition position = (EnumPilePosition)((Object)state.func_177229_b(PILE_POSITION));
        if (position != EnumPilePosition.INTERIOR) {
            list.add(AABB_SLAB_BOTTOM);
            switch (position) {
                case BACK: {
                    list.add(AABB_QTR_TOP_SOUTH);
                    break;
                }
                case FRONT: {
                    list.add(AABB_QTR_TOP_NORTH);
                    break;
                }
                case SIDE_LEFT: {
                    list.add(AABB_QTR_TOP_EAST);
                    break;
                }
                case SIDE_RIGHT: {
                    list.add(AABB_QTR_TOP_WEST);
                    break;
                }
                case CORNER_BACK_LEFT: {
                    list.add(AABB_OCT_TOP_NE);
                    break;
                }
                case CORNER_BACK_RIGHT: {
                    list.add(AABB_OCT_TOP_NW);
                    break;
                }
                case CORNER_FRONT_LEFT: {
                    list.add(AABB_OCT_TOP_SE);
                    break;
                }
                case CORNER_FRONT_RIGHT: {
                    list.add(AABB_OCT_TOP_SW);
                    break;
                }
            }
        } else {
            list.add(Block.field_185505_j);
        }
        return list;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPilePosition)((Object)state.func_177229_b(PILE_POSITION))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PILE_POSITION, (Comparable)((Object)EnumPilePosition.values()[meta]));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePile();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        ICharcoalPileComponent kiln;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICharcoalPileComponent && (kiln = (ICharcoalPileComponent)tile).getMultiblockLogic().isConnected() && kiln.getMultiblockLogic().getController().isAssembled() && kiln.getMultiblockLogic().getController().isActive()) {
            return 10;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TilePile pile = TileUtil.getTile((IBlockAccess)world, pos, TilePile.class);
        if (pile == null) {
            return;
        }
        MultiblockLogic logic = (MultiblockLogic)pile.getMultiblockLogic();
        if (logic.isConnected() && ((ICharcoalPileControllerInternal)logic.getController()).isAssembled() && ((ICharcoalPileControllerInternal)logic.getController()).isActive() && state.func_177229_b(PILE_POSITION) != EnumPilePosition.INTERIOR) {
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3) - 0.5, (double)f1 + 0.5, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.getPileType() == EnumPileType.WOOD) {
            ArrayList<ItemStack> woodPiles = new ArrayList<ItemStack>();
            for (ITree tree : TreeManager.treeRoot.getIndividualTemplates()) {
                IAlleleTreeSpecies treeSpecies = tree.getGenome().getPrimary();
                ItemStack woodPile = BlockPile.createWoodPile(treeSpecies);
                woodPiles.add(woodPile);
            }
            subItems.addAll(woodPiles);
        } else if (this.getPileType() == EnumPileType.DIRT) {
            super.func_149666_a(item, tab, subItems);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        if (playerIn.func_70093_af()) {
            return false;
        }
        TilePile pile = TileUtil.getTile((IBlockAccess)worldIn, pos, TilePile.class);
        if (pile == null) {
            return false;
        }
        ICharcoalPileControllerInternal controller = ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).getController();
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            String validationError;
            if (!controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                long tick = worldIn.func_82737_E();
                if (tick > this.previousMessageTick + 20L) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(validationError));
                    this.previousMessageTick = tick;
                }
                return true;
            }
        } else if (BlockCandle.lightingItems.contains(heldItem.func_77973_b()) && ((MultiblockLogicCharcoalPile)pile.getMultiblockLogic()).isConnected() && controller.isAssembled() && !controller.isActive()) {
            controller.setActive(true);
            return true;
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184607_cu());
            this.drop.set(this.getPileDrop((IBlockAccess)world, pos, state, fortune));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> drops = this.drop.get();
        this.drop.remove();
        if (drops == null) {
            drops = this.getPileDrop(world, pos, state, fortune);
        }
        return drops;
    }

    private List<ItemStack> getPileDrop(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICharcoalPileComponent) {
            ICharcoalPileComponent pile = (ICharcoalPileComponent)tile;
            if (this.getPileType() == EnumPileType.ASH) {
                IWoodProvider woodProvider = pile.getTreeSpecies().getWoodProvider();
                int charcoalAmount = woodProvider.getCarbonization();
                ItemStack charcoal = new ItemStack(Items.field_151044_h, charcoalAmount, 1);
                while (RANDOM.nextFloat() < woodProvider.getCharcoalChance(charcoalAmount)) {
                    charcoal.func_190917_f(1);
                }
                list.add(charcoal);
                int ashAmount = (int)((double)charcoalAmount / 1.5);
                if (ashAmount <= 0) {
                    ashAmount = 1;
                }
                list.add(new ItemStack((Item)PluginCore.getItems().ash, ashAmount));
            } else if (this.getPileType() == EnumPileType.DIRT) {
                list.add(new ItemStack((Block)this));
            } else {
                list.add(BlockPile.createWoodPile(pile.getTreeSpecies()));
            }
        }
        return list;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(PILE_POSITION) == EnumPilePosition.INTERIOR;
    }

    public int func_149717_k(IBlockState state) {
        if (state.func_177229_b(PILE_POSITION) != EnumPilePosition.INTERIOR) {
            return 0;
        }
        return super.func_149717_k(state);
    }

    public boolean func_149730_j(IBlockState state) {
        return state.func_177229_b(PILE_POSITION) == EnumPilePosition.INTERIOR;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(PILE_POSITION) == EnumPilePosition.INTERIOR;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b(PILE_POSITION) != EnumPilePosition.INTERIOR) {
            return EnumBlockRenderType.INVISIBLE;
        }
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper(this, new PileStateMapper());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.getPileType() == EnumPileType.WOOD) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ICharcoalPileComponent) {
                return BlockPile.createWoodPile(((ICharcoalPileComponent)tile).getTreeSpecies());
            }
        } else if (this.getPileType() == EnumPileType.DIRT) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        if (this.getPileType() == EnumPileType.WOOD) {
            manager.registerItemModel(item, 0, "wood_pile");
        } else if (this.getPileType() == EnumPileType.DIRT) {
            manager.registerItemModel(item, 0, "dirt_pile");
        } else if (this.getPileType() == EnumPileType.ASH) {
            manager.registerItemModel(item, 0, "ash_pile");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies)allele;
            treeSpecies.getWoodProvider().registerSprites(Item.func_150898_a((Block)this), manager);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return ParticleHelper.addBlockHitEffects(world, target.func_178782_a(), target.field_178784_b, effectRenderer, this.particleCallback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState blockState = world.func_180495_p(pos);
        return ParticleHelper.addDestroyEffects(world, this, blockState, pos, effectRenderer, this.particleCallback);
    }

    @Nullable
    public static IAlleleTreeSpecies getTreeSpecies(ItemStack stack) {
        String treeSpeciesUid;
        IAllele allele;
        NBTTagCompound tagCompound;
        if (!stack.func_190926_b() && stack.func_77978_p() != null && (tagCompound = stack.func_77978_p()).func_74764_b("TreeSpecies") && (allele = AlleleManager.alleleRegistry.getAllele(treeSpeciesUid = tagCompound.func_74779_i("TreeSpecies"))) instanceof IAlleleSpecies) {
            return (IAlleleTreeSpecies)allele;
        }
        return null;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile;
        if (this.getPileType() == EnumPileType.WOOD && (tile = world.func_175625_s(pos)) instanceof ICharcoalPileComponent) {
            IAlleleTreeSpecies tree = ((ICharcoalPileComponent)tile).getTreeSpecies();
            ItemStack wood = tree.getWoodProvider().getWoodStack();
            Block block = Block.func_149634_a((Item)wood.func_77973_b());
            return block.getFlammability(world, pos, face);
        }
        return super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile;
        if (this.getPileType() == EnumPileType.WOOD && (tile = world.func_175625_s(pos)) instanceof ICharcoalPileComponent) {
            IAlleleTreeSpecies tree = ((ICharcoalPileComponent)tile).getTreeSpecies();
            ItemStack wood = tree.getWoodProvider().getWoodStack();
            Block block = Block.func_149634_a((Item)wood.func_77973_b());
            return block.getFireSpreadSpeed(world, pos, face);
        }
        return super.getFireSpreadSpeed(world, pos, face);
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile;
        if (this.getPileType() == EnumPileType.WOOD && (tile = world.func_175625_s(pos)) instanceof ICharcoalPileComponent) {
            IAlleleTreeSpecies tree = ((ICharcoalPileComponent)tile).getTreeSpecies();
            ItemStack wood = tree.getWoodProvider().getWoodStack();
            Block block = Block.func_149634_a((Item)wood.func_77973_b());
            return block.func_176203_a(wood.func_77960_j()).func_185887_b(world, pos);
        }
        return super.func_176195_g(blockState, world, pos);
    }

    public static ItemStack createWoodPile(IAlleleTreeSpecies treeSpecies) {
        ItemStack stack = new ItemStack((Block)PluginArboriculture.getBlocks().piles.get((Object)EnumPileType.WOOD));
        NBTTagCompound nbtItem = new NBTTagCompound();
        nbtItem.func_74778_a("TreeSpecies", treeSpecies.getUID());
        stack.func_77982_d(nbtItem);
        return stack;
    }

    public abstract EnumPileType getPileType();
}

