package forestry.core.multiblock;

import java.util.Set;

import forestry.api.multiblock.IMultiblockController;
import forestry.core.utils.Log;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * In your mod, subscribe this on both the client and server sides side to handle chunk
 * load events for your multiblock machines.
 * Chunks can load asynchronously in environments like MCPC+, so we cannot
 * process any blocks that are in chunks which are still loading.
 */
public class MultiblockEventHandler {
	@SubscribeEvent(priority = EventPriority.NORMAL)
	public void onChunkLoad(ChunkEvent.Load loadEvent) {
		Chunk chunk = loadEvent.getChunk();
		World world = loadEvent.getWorld();
		MultiblockRegistry.onChunkLoaded(world, chunk.field_76635_g, chunk.field_76647_h);
	}

	// Cleanup, for nice memory usageness
	@SubscribeEvent(priority = EventPriority.NORMAL)
	public void onWorldUnload(WorldEvent.Unload unloadWorldEvent) {
		MultiblockRegistry.onWorldUnloaded(unloadWorldEvent.getWorld());
	}
	
	@SubscribeEvent
	public void onWorldRenderLast(RenderWorldLastEvent event){
		try{
			World world = Minecraft.func_71410_x().field_71441_e;
			Set<IMultiblockControllerInternal> controllers = MultiblockRegistry.getControllersFromWorld(world);
			if(!controllers.isEmpty()){
		        float partialTicks = event.getPartialTicks();
				EntityPlayer player = Minecraft.func_71410_x().field_71439_g;
		        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
		        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
		        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
		        
		        GlStateManager.func_179094_E();
		        GlStateManager.func_179147_l();
		        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
		        GlStateManager.func_179090_x();
		        GlStateManager.func_187441_d(2.0F);
	            GlStateManager.func_179132_a(false);
		        for(IMultiblockController controller : controllers){
					if(controller != null){
						BlockPos lastErrorPosition = controller.getLastValidationErrorPosition();
						if(lastErrorPosition != null){
							if(world.func_175667_e(lastErrorPosition) && player.func_174818_b(lastErrorPosition) < 64F){
								AxisAlignedBB box = Block.field_185505_j.func_72317_d(lastErrorPosition.func_177958_n() - playerX, lastErrorPosition.func_177956_o() - playerY, lastErrorPosition.func_177952_p() - playerZ);
								RenderGlobal.func_189697_a(box, 1.0F, 0.0F, 0.0F, 0.25F);
								RenderGlobal.func_189696_b(box, 1.0F, 0.0F, 0.0F, 0.125F);
							}
						}
					}
				}
				
	            GlStateManager.func_179132_a(true);
		        GlStateManager.func_179098_w();
		        GlStateManager.func_179084_k();
		        GlStateManager.func_179121_F();
			}
		}catch(Exception e){
			Log.error("Failed to render the position of a multiblock exeption.", e);
		}
	}
}
