/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.items.ItemBlockForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockPile<B extends Block> extends ItemBlockForestry<Block> {

	public ItemBlockPile(Block block) {
		super(block);
		func_77656_e(0);
		func_77627_a(true);
	}

	@Override
	public B func_179223_d() {
		//noinspection unchecked
		return (B) super.func_179223_d();
	}

	@Override
	public int func_77647_b(int i) {
		return i;
	}

	@Override
	public String func_77653_i(ItemStack itemstack) {
		if (field_150939_a == PluginArboriculture.getBlocks().piles.get(EnumPileType.WOOD)) {
			if (itemstack.func_77978_p() == null) {
				return "Unknown";
			}
			IAlleleTreeSpecies species = BlockPile.getTreeSpecies(itemstack);
			if (species == null) {
				return "Unknown";
			}

			String customTreeKey = "for.trees.custom.pile." + species.getUnlocalizedName().replace("trees.species.", "");
			if (Translator.canTranslateToLocal(customTreeKey)) {
				return Translator.translateToLocal(customTreeKey);
			}
			String typeString = Translator.translateToLocal("for.trees.grammar.pile.type");
			return Translator.translateToLocal("for.trees.grammar.pile").replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", typeString);
		} else {
			return Translator.translateToLocal("for.trees.pile.dirt");
		}
	}

	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
		boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);

		if (placed) {
			if (field_150939_a == PluginArboriculture.getBlocks().piles.get(EnumPileType.WOOD)) {
				if (field_150939_a.hasTileEntity(newState)) {
					if (stack.func_77978_p() != null) {
						TilePile tile = TileUtil.getTile(world, pos, TilePile.class);
						if (tile != null) {
							tile.func_145839_a(stack.func_77978_p());
							tile.func_174878_a(pos);
							tile.func_70296_d();
						}
					}
				}
			}
		}

		return placed;
	}
}
