/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WoodTextures {
    protected static final Map<String, Texture> textures = new HashMap<String, Texture>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deserializeFile(IResourceManager resourceManager) {
        block10: {
            try {
                InputStream stream = resourceManager.func_110536_a(new ResourceLocation("forestry:textures/woodTextures.json")).func_110527_b();
                try (JsonReader reader = null;){
                    reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream)));
                    JsonElement json = Streams.parse((JsonReader)reader);
                    if (json.isJsonObject()) {
                        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                            JsonElement ele = (JsonElement)entry.getValue();
                            if (ele.isJsonObject()) {
                                textures.put((String)entry.getKey(), WoodTextures.loadTexture(ele.getAsJsonObject()));
                                continue;
                            }
                            if (!ele.isJsonArray()) continue;
                            ImmutableMap.Builder locations = new ImmutableMap.Builder();
                            for (JsonElement eleEntry : ele.getAsJsonArray()) {
                                JsonObject obj;
                                if (!eleEntry.isJsonObject() || !(obj = eleEntry.getAsJsonObject()).has("kind") || !obj.get("kind").isJsonPrimitive() || !obj.get("kind").getAsJsonPrimitive().isString()) continue;
                                String kind = obj.get("kind").getAsString();
                                locations.put((Object)kind, (Object)WoodTextures.loadTexture(obj));
                            }
                            textures.put((String)entry.getKey(), new KindTexture((ImmutableMap<String, SimpleTexture>)locations.build()));
                        }
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block10;
                e.printStackTrace();
            }
        }
    }

    private static SimpleTexture loadTexture(JsonObject obj) {
        ImmutableMap.Builder locations = new ImmutableMap.Builder();
        for (Map.Entry eleEntry : obj.entrySet()) {
            JsonElement e = (JsonElement)eleEntry.getValue();
            if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString()) continue;
            locations.put(eleEntry.getKey(), (Object)e.getAsString());
        }
        return new SimpleTexture((ImmutableMap<String, String>)locations.build());
    }

    public static ImmutableMap<String, String> getLocations(IWoodType woodType, WoodBlockKind blockKind) {
        String kindName = blockKind.toString();
        Texture kindTex = textures.get(kindName);
        Texture tex = textures.get(woodType.func_176610_l().toLowerCase(Locale.ENGLISH));
        HashMap<String, String> locations = new HashMap<String, String>();
        if (kindTex != null && kindTex instanceof SimpleTexture) {
            locations.putAll((Map<String, String>)((SimpleTexture)kindTex).locations);
        }
        if (tex != null) {
            if (tex instanceof SimpleTexture) {
                locations.putAll((Map<String, String>)((SimpleTexture)tex).locations);
            } else {
                SimpleTexture kind = (SimpleTexture)((KindTexture)tex).kindLocations.get((Object)kindName);
                locations.putAll((Map<String, String>)kind.locations);
            }
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        block14: for (Map.Entry location : locations.entrySet()) {
            String texture;
            switch (texture = (String)location.getValue()) {
                case "plank": {
                    texture = woodType.getPlankTexture();
                    break;
                }
                case "bark": {
                    texture = woodType.getBarkTexture();
                    break;
                }
                case "heart": {
                    texture = woodType.getHeartTexture();
                    break;
                }
                case "doorUp": {
                    texture = woodType.getDoorUpperTexture();
                    break;
                }
                case "doorLow": {
                    texture = woodType.getDoorLowerTexture();
                    break;
                }
                default: {
                    builder.put(location.getKey(), (Object)texture.replace("%woodType", woodType.func_176610_l().toLowerCase(Locale.ENGLISH)));
                    continue block14;
                }
            }
            builder.put(location.getKey(), (Object)texture);
        }
        return builder.build();
    }

    private static class KindTexture
    extends Texture {
        public final ImmutableMap<String, SimpleTexture> kindLocations;

        public KindTexture(ImmutableMap<String, SimpleTexture> kindLocations) {
            this.kindLocations = kindLocations;
        }
    }

    private static class SimpleTexture
    extends Texture {
        public final ImmutableMap<String, String> locations;

        public SimpleTexture(ImmutableMap<String, String> locations) {
            this.locations = locations;
        }
    }

    private static class Texture {
        private Texture() {
        }
    }
}

